/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.coins.atm.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.money.coins.atm.data.ATMExchangeButtonData;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.util.GsonHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ATMData {
    public final ChainData chain;
    private final List<ATMExchangeButtonData> exchangeButtons;

    public final List<ATMExchangeButtonData> getExchangeButtons() {
        return this.exchangeButtons;
    }

    private ATMData(JsonObject jsonData, ChainData chain) throws JsonSyntaxException, ResourceLocationException {
        this.chain = chain;
        ArrayList<ATMExchangeButtonData> temp = new ArrayList<ATMExchangeButtonData>();
        JsonArray exchangeButtonDataList = GsonHelper.m_13832_((JsonObject)jsonData, (String)"ConversionButtons", (JsonArray)GsonHelper.m_13933_((JsonObject)jsonData, (String)"ExchangeButtons"));
        for (int i = 0; i < exchangeButtonDataList.size(); ++i) {
            try {
                temp.add(ATMExchangeButtonData.parse(exchangeButtonDataList.get(i).getAsJsonObject()));
                continue;
            }
            catch (JsonSyntaxException | ResourceLocationException e) {
                LightmansCurrency.LogError("Error parsing Exchange Button #" + (i + 1) + ".", e);
            }
        }
        this.exchangeButtons = ImmutableList.copyOf(temp);
    }

    private ATMData(List<ATMExchangeButtonData> exchangeButtons, ChainData chain) {
        this.exchangeButtons = ImmutableList.copyOf(exchangeButtons);
        this.chain = chain;
    }

    public JsonObject save() {
        JsonObject data = new JsonObject();
        JsonArray exchangeButtonDataList = new JsonArray();
        for (ATMExchangeButtonData exchangeButton : this.exchangeButtons) {
            exchangeButtonDataList.add((JsonElement)exchangeButton.save());
        }
        data.add("ExchangeButtons", (JsonElement)exchangeButtonDataList);
        return data;
    }

    public static ATMData parse(JsonObject json, ChainData chain) throws JsonSyntaxException, ResourceLocationException {
        return new ATMData(json, chain);
    }

    public static Builder builder(ChainData.Builder parent) {
        return new Builder(parent);
    }

    @Deprecated(since="2.2.0.0")
    public static void parseDeprecated(ChainData.Builder builder) {
        File file = new File("config/lightmanscurrency/ATMData.json");
        if (file.exists()) {
            try {
                JsonObject fileData = GsonHelper.m_13864_((String)Files.readString(file.toPath()));
                ATMData data = new ATMData(fileData, null);
                Builder atmBuilder = builder.atmBuilder();
                for (ATMExchangeButtonData b : data.getExchangeButtons()) {
                    atmBuilder.addButton(b);
                }
            }
            catch (JsonSyntaxException | IOException throwable) {
                // empty catch block
            }
        }
    }

    public static final class Builder {
        private final ChainData.Builder parent;
        private final List<ATMExchangeButtonData> exchangeButtons = new ArrayList<ATMExchangeButtonData>();

        private Builder(ChainData.Builder parent) {
            this.parent = parent;
        }

        public ChainData.Builder back() {
            return this.parent;
        }

        public List<ATMExchangeButtonData> viewExchangeButtons() {
            return ImmutableList.copyOf(this.exchangeButtons);
        }

        public Builder addButton(ATMExchangeButtonData button) {
            this.exchangeButtons.add(button);
            return this;
        }

        public Builder addButtons(List<ATMExchangeButtonData> list) {
            this.exchangeButtons.addAll(list);
            return this;
        }

        public Builder removeButton(int index) {
            this.exchangeButtons.remove(index);
            return this;
        }

        public Builder accept(Consumer<Builder> consumer) {
            consumer.accept(this);
            return this;
        }

        public ATMData build(ChainData chain) {
            return new ATMData(this.exchangeButtons, chain);
        }
    }
}

