/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.coins.atm.icons.builtin;

import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FixedSizeSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteSource;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin.NormalSprite;
import io.github.lightman314.lightmanscurrency.api.money.coins.atm.icons.ATMIconData;
import io.github.lightman314.lightmanscurrency.api.money.coins.atm.icons.IconType;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.atm.ATMExchangeButton;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SimpleArrowIcon
extends ATMIconData {
    public static final ResourceLocation TYPE_NAME = VersionUtil.lcResource("small_arrow");
    public static final IconType TYPE = IconType.create(TYPE_NAME, SimpleArrowIcon::new);
    private final ArrowType direction;

    public SimpleArrowIcon(JsonObject data) throws JsonSyntaxException, ResourceLocationException {
        super(data);
        if (data.has("direction")) {
            this.direction = ArrowType.parse(GsonHelper.m_13906_((JsonObject)data, (String)"direction"));
        } else {
            LightmansCurrency.LogWarning("Simple Arrow icon has no defined direction. Will assume it's pointing right.");
            this.direction = ArrowType.RIGHT;
        }
    }

    public SimpleArrowIcon(int xPos, int yPos, ArrowType direction) {
        super(xPos, yPos);
        this.direction = direction;
    }

    @Override
    protected void saveAdditional(JsonObject data) {
        data.addProperty("direction", this.direction.name());
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE_NAME;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(ATMExchangeButton button, EasyGuiGraphics gui, boolean isHovered) {
        this.direction.getSprite(isHovered).render(gui, this.xPos, this.yPos);
    }

    public static enum ArrowType {
        UP,
        DOWN,
        LEFT,
        RIGHT;

        private final Supplier<FixedSizeSprite> normalSprite = Suppliers.memoize(() -> new NormalSprite(SpriteSource.createTop(this.getSpriteID(), 6, 6)));
        private final Supplier<FixedSizeSprite> hoveredSprite = Suppliers.memoize(() -> new NormalSprite(SpriteSource.createBottom(this.getSpriteID(), 6, 6)));

        private ResourceLocation getSpriteID() {
            return VersionUtil.lcResource("common/widgets/atm_arrow_" + this.name().toLowerCase(Locale.ENGLISH));
        }

        private FixedSizeSprite getSprite(boolean hovered) {
            return hovered ? this.hoveredSprite.get() : this.normalSprite.get();
        }

        static ArrowType parse(String value) {
            for (ArrowType type : ArrowType.values()) {
                if (!type.name().equalsIgnoreCase(value)) continue;
                return type;
            }
            return RIGHT;
        }
    }
}

