/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.paygate;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.misc.settings.client.widget.DirectionalSettingsWidget;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyValueWidget;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeInteractionHandler;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.IntParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.paygate.PaygateTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PaygateTradeEditClientTab
extends TraderStorageClientTab<PaygateTradeEditTab>
implements TradeInteractionHandler,
IMouseListener {
    TradeButton tradeDisplay;
    MoneyValueWidget priceSelection;
    EditBox durationInput;
    EditBox descriptionInput;
    EditBox tooltipInput;
    IconButton ticketStubButton;
    private boolean descriptionEdit = true;
    private boolean priceEdit = true;

    public PaygateTradeEditClientTab(Object screen, PaygateTradeEditTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_TRADER;
    }

    public MutableComponent getTooltip() {
        return EasyText.empty();
    }

    @Override
    public boolean tabVisible() {
        return false;
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public int getTradeRuleTradeIndex() {
        return ((PaygateTradeEditTab)this.commonTab).getTradeIndex();
    }

    private boolean isTicketTrade() {
        PaygateTradeData trade = ((PaygateTradeEditTab)this.commonTab).getTrade();
        return trade != null && trade.isTicketTrade();
    }

    private boolean priceEditMode() {
        return this.priceEdit && !this.isTicketTrade();
    }

    private boolean detailEditMode() {
        return !this.priceEditMode();
    }

    private boolean isDescriptionEdit() {
        return this.descriptionEdit;
    }

    private boolean isTooltipEdit() {
        return !this.descriptionEdit;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        PaygateTradeData trade = ((PaygateTradeEditTab)this.commonTab).getTrade();
        this.tradeDisplay = this.addChild(((TradeButton.Builder)TradeButton.builder().position(screenArea.pos.offset(10, 18))).context(((ITraderStorageMenu)this.menu)::getContext).trade(((PaygateTradeEditTab)this.commonTab)::getTrade).build());
        this.tradeDisplay.setPosition(screenArea.pos.offset(10, 18));
        this.priceSelection = this.addChild(((MoneyValueWidget.Builder)((MoneyValueWidget.Builder)MoneyValueWidget.builder().position(screenArea.pos.offset(15, 40))).oldIfNotFirst(firstOpen, this.priceSelection).startingValue(trade).valueHandler(this::onValueChanged).addon(EasyAddonHelper.visibleCheck(this::priceEditMode))).build());
        this.ticketStubButton = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(164, 130))).pressAction(this::ToggleTicketStubHandling)).icon(this::GetTicketStubIcon).addon(EasyAddonHelper.tooltip(this::getTicketStubButtonTooltip))).addon(EasyAddonHelper.visibleCheck(this::isTicketTrade))).build());
        this.durationInput = this.addChild(TextInputUtil.intBuilder().position(screenArea.pos.offset(15, 50)).size(80, 18).apply(IntParser.builder().min(1).max(PaygateTraderData::getMaxDuration).empty(1).consumer()).startingValue(trade == null ? 1 : trade.getDuration()).handler(((PaygateTradeEditTab)this.commonTab)::setDuration).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(15, 75))).pressAction(this::increaseLevel)).sprite(SpriteUtil.BUTTON_SIGN_PLUS).addon(EasyAddonHelper.activeCheck(this::canIncreaseLevel))).addon(EasyAddonHelper.visibleCheck(this::detailEditMode))).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(15, 85))).pressAction(this::decreaseLevel)).sprite(SpriteUtil.BUTTON_SIGN_MINUS).addon(EasyAddonHelper.activeCheck(this::canDecreaseLevel))).addon(EasyAddonHelper.visibleCheck(this::detailEditMode))).build());
        this.addChild(((DirectionalSettingsWidget.Builder)((DirectionalSettingsWidget.Builder)DirectionalSettingsWidget.builder().position(screenArea.pos.offset(screenArea.width - 44, 52))).object(((PaygateTradeEditTab)this.commonTab)::getTrade).handlers(this::ToggleOutputSide).addon(EasyAddonHelper.visibleCheck(this::detailEditMode))).build());
        this.descriptionInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 15, screenArea.y + 110, screenArea.width - 30, 18, (Component)EasyText.empty()));
        if (trade != null) {
            this.descriptionInput.m_94144_(trade.getDescription());
        }
        this.descriptionInput.m_94151_(((PaygateTradeEditTab)this.commonTab)::setDescription);
        this.descriptionInput.f_93624_ = this.isDescriptionEdit();
        this.tooltipInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 15, screenArea.y + 110, screenArea.width - 30, 18, (Component)EasyText.empty()));
        this.tooltipInput.m_94199_(256);
        if (trade != null) {
            this.tooltipInput.m_94144_(trade.getTooltip());
        }
        this.tooltipInput.m_94151_(((PaygateTradeEditTab)this.commonTab)::setTooltip);
        this.tooltipInput.f_93624_ = this.isTooltipEdit();
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(7, 110))).sprite(SpriteUtil.createNeutralToggle(this::isDescriptionEdit)).pressAction(() -> {
            this.descriptionEdit = !this.descriptionEdit;
        })).addon(EasyAddonHelper.visibleCheck(this::detailEditMode))).build());
    }

    @Override
    public void renderBG(EasyGuiGraphics gui) {
        PaygateTradeData trade = ((PaygateTradeEditTab)this.commonTab).getTrade();
        if (trade == null) {
            return;
        }
        this.durationInput.f_93624_ = this.detailEditMode();
        this.descriptionInput.f_93624_ = this.detailEditMode() && this.isDescriptionEdit();
        boolean bl = this.tooltipInput.f_93624_ = this.detailEditMode() && this.isTooltipEdit();
        if (this.detailEditMode()) {
            gui.drawString((Component)LCText.GUI_TRADER_PAYGATE_DURATION.get(new Object[0]), 17, 40, 0x404040);
            MutableComponent unitText = LCText.GUI_TRADER_PAYGATE_DURATION_UNIT.get(new Object[0]);
            int unitWidth = gui.font.m_92852_((FormattedText)unitText);
            gui.drawString((Component)unitText, 100, 55, 0x404040);
            gui.drawString((Component)LCText.GUI_TRADER_PAYGATE_LEVEL.get(trade.getRedstoneLevel()), 27, 81, 0x404040);
            MutableComponent label = this.isDescriptionEdit() ? LCText.GUI_TRADER_PAYGATE_DESCRIPTION.get(new Object[0]) : LCText.GUI_TRADER_PAYGATE_TOOLTIP.get(new Object[0]);
            gui.drawString((Component)label, 17, 100, 0x404040);
            TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_SETTINGS_OUTPUT_SIDE.get(new Object[0]), ((ITraderStorageScreen)this.screen).getXSize() - 44, 40, 0x404040);
        }
    }

    private Component getTicketStubButtonTooltip() {
        PaygateTradeData trade = ((PaygateTradeEditTab)this.commonTab).getTrade();
        if (trade != null) {
            return trade.shouldStoreTicketStubs() ? LCText.TOOLTIP_TRADER_PAYGATE_TICKET_STUBS_KEEP.get(new Object[0]) : LCText.TOOLTIP_TRADER_PAYGATE_TICKET_STUBS_GIVE.get(new Object[0]);
        }
        return null;
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        this.tradeDisplay.HandleInteractionClick((int)mouseX, (int)mouseY, button, this);
        return false;
    }

    @Override
    public void HandleTradeInputInteraction(TraderData trader, TradeData trade, TradeInteractionData data, int index) {
        if (trade instanceof PaygateTradeData) {
            PaygateTradeData t = (PaygateTradeData)trade;
            if (!this.priceEdit) {
                this.priceEdit = true;
            } else if (TicketItem.isMasterTicket(((ITraderStorageMenu)this.menu).getHeldItem())) {
                ((PaygateTradeEditTab)this.commonTab).setTicket(((ITraderStorageMenu)this.menu).getHeldItem());
            } else if (t.isTicketTrade()) {
                ((PaygateTradeEditTab)this.commonTab).setTicket(ItemStack.f_41583_);
            }
        }
    }

    @Override
    public void HandleTradeOutputInteraction(TraderData trader, TradeData trade, TradeInteractionData data, int index) {
        this.priceEdit = false;
    }

    @Override
    public void HandleOtherTradeInteraction(TraderData trader, TradeData trade, TradeInteractionData data) {
    }

    public void onValueChanged(MoneyValue value) {
        ((PaygateTradeEditTab)this.commonTab).setPrice(value);
    }

    private boolean canIncreaseLevel() {
        PaygateTradeData trade = ((PaygateTradeEditTab)this.commonTab).getTrade();
        return trade != null && trade.getRedstoneLevel() < 15;
    }

    private boolean canDecreaseLevel() {
        PaygateTradeData trade = ((PaygateTradeEditTab)this.commonTab).getTrade();
        return trade != null && trade.getRedstoneLevel() > 1;
    }

    private void increaseLevel() {
        PaygateTradeData trade = ((PaygateTradeEditTab)this.commonTab).getTrade();
        if (trade != null) {
            ((PaygateTradeEditTab)this.commonTab).setLevel(trade.getRedstoneLevel() + 1);
        }
    }

    private void decreaseLevel() {
        PaygateTradeData trade = ((PaygateTradeEditTab)this.commonTab).getTrade();
        if (trade != null) {
            ((PaygateTradeEditTab)this.commonTab).setLevel(trade.getRedstoneLevel() - 1);
        }
    }

    @Override
    protected void OpenMessage(LazyPacketData clientData) {
        if (clientData.contains("PriceEdit")) {
            this.priceEdit = clientData.getBoolean("PriceEdit");
        }
    }

    private IconData GetTicketStubIcon() {
        PaygateTradeData trade = ((PaygateTradeEditTab)this.commonTab).getTrade();
        boolean shouldStore = trade != null && trade.shouldStoreTicketStubs();
        return shouldStore ? ItemIcon.ofItem((ItemLike)Items.f_42009_) : ItemIcon.ofItem((ItemLike)Items.f_42680_);
    }

    private void ToggleTicketStubHandling(EasyButton button) {
        PaygateTradeData trade = ((PaygateTradeEditTab)this.commonTab).getTrade();
        if (trade != null) {
            ((PaygateTradeEditTab)this.commonTab).setTicketStubHandling(!trade.shouldStoreTicketStubs());
        }
    }

    private void ToggleOutputSide(Direction side, boolean inverse) {
        PaygateTradeData trade = ((PaygateTradeEditTab)this.commonTab).getTrade();
        if (trade != null) {
            DirectionalSettingsState state = trade.getSidedState(side);
            ((PaygateTradeEditTab)this.commonTab).setOutputSide(side, state.getNext(trade));
        }
    }
}

