/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util.text_inputs;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.DoubleParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.FloatParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.IntParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.LongParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.ResourceParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextBoxWrapper;
import io.github.lightman314.lightmanscurrency.util.NumberUtil;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TextInputUtil {
    public static Builder<String> stringBuilder() {
        return new Builder<String>(s -> s);
    }

    public static Builder<Integer> intBuilder() {
        return new Builder<Integer>(IntParser.DEFAULT).filter(NumberUtil::IsIntegerOrEmpty);
    }

    public static Builder<Long> longBuilder() {
        return new Builder<Long>(LongParser.DEFAULT).filter(NumberUtil::IsLongOrEmpty);
    }

    public static Builder<Float> floatBuilder() {
        return new Builder<Float>(FloatParser.DEFAULT).filter(NumberUtil::IsFloatOrEmpty);
    }

    public static Builder<Double> doubleBuilder() {
        return new Builder<Double>(DoubleParser.DEFAULT).filter(NumberUtil::IsDoubleOrEmpty);
    }

    public static Builder<ResourceLocation> resourceBuilder() {
        return TextInputUtil.resourceBuilder(false);
    }

    public static Builder<ResourceLocation> resourceBuilder(boolean requireNamespace) {
        return new Builder<ResourceLocation>(requireNamespace ? ResourceParser.DEFAULT : ResourceParser.REQUIRE_NAMESPACE).filter(ResourceParser::isResourceOrEmpty);
    }

    public static <T> Consumer<String> stringResponder(Consumer<T> handler, Function<String, T> reader) {
        return s -> {
            Object result = reader.apply((String)s);
            if (result != null) {
                handler.accept(result);
            }
        };
    }

    public static class Builder<T> {
        private Font font;
        private ScreenArea area;
        private Consumer<T> handler;
        @Nullable
        private Predicate<String> filter;
        private Function<String, T> parser;
        private Function<T, String> writer;
        String startingValue;
        private int maxLength;
        @Nullable
        private Integer color;
        private Component message;
        private boolean renderBG;

        private Builder(Function<String, T> parser) {
            this.font = Minecraft.m_91087_().f_91062_;
            this.area = ScreenArea.of(0, 0, 100, 20);
            this.handler = v -> {};
            this.filter = null;
            this.writer = String::valueOf;
            this.startingValue = "";
            this.maxLength = 32;
            this.color = null;
            this.message = EasyText.empty();
            this.renderBG = true;
            this.parser = parser;
        }

        public Builder<T> font(Font font) {
            this.font = font;
            return this;
        }

        public Builder<T> copyValue(@Nullable EditBox box) {
            if (box != null) {
                this.startingString(box.m_94155_());
            }
            return this;
        }

        public Builder<T> copyValue(@Nullable TextBoxWrapper<T> box) {
            if (box != null) {
                this.startingString(box.getString());
            }
            return this;
        }

        public Builder<T> startingString(String value) {
            this.startingValue = value;
            return this;
        }

        public Builder<T> startingValue(T value) {
            Float f;
            Double d;
            if (value instanceof Double && (d = (Double)value) == 0.0 || value instanceof Float && (f = (Float)value).floatValue() == 0.0f) {
                this.startingString("0");
            } else {
                this.startingString(String.valueOf(value));
            }
            return this;
        }

        public Builder<T> maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder<T> textColor(int color) {
            this.color = color;
            return this;
        }

        public Builder<T> message(Component message) {
            this.message = Objects.requireNonNull(message);
            return this;
        }

        public Builder<T> position(int x, int y) {
            this.area = this.area.atPosition(x, y);
            return this;
        }

        public Builder<T> position(ScreenPosition pos) {
            this.area = this.area.atPosition(pos);
            return this;
        }

        public Builder<T> width(int width) {
            this.area = this.area.ofSize(width, this.area.height);
            return this;
        }

        public Builder<T> height(int height) {
            this.area = this.area.ofSize(this.area.width, height);
            return this;
        }

        public Builder<T> size(int width, int height) {
            this.area = this.area.ofSize(width, height);
            return this;
        }

        public Builder<T> area(ScreenArea area) {
            this.area = Objects.requireNonNull(area);
            return this;
        }

        public Builder<T> handler(Consumer<T> handler) {
            this.handler = handler;
            return this;
        }

        public Builder<T> filter(Predicate<String> filter) {
            this.filter = filter;
            return this;
        }

        public Builder<T> parser(Function<String, T> parser) {
            this.parser = parser;
            return this;
        }

        public Builder<T> writer(Function<T, String> writer) {
            this.writer = writer;
            return this;
        }

        public Builder<T> noBorder() {
            this.renderBG = false;
            return this;
        }

        public Builder<T> apply(Consumer<Builder<T>> application) {
            application.accept(this);
            return this;
        }

        public TextBoxWrapper.Builder<T> wrap() {
            return TextBoxWrapper.builder(this.build(), this.handler, this.parser, this.writer);
        }

        public EditBox build() {
            EditBox box = new EditBox(this.font, this.area.x, this.area.y, this.area.width, this.area.height, this.message);
            box.m_94144_(this.startingValue);
            if (this.filter != null) {
                box.m_94153_(this.filter);
            }
            if (this.color != null) {
                box.m_94202_(this.color.intValue());
            }
            box.m_94151_(s -> this.handler.accept(this.parser.apply((String)s)));
            box.m_94199_(this.maxLength);
            box.m_94182_(this.renderBG);
            return box;
        }
    }
}

