/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import io.github.lightman314.lightmanscurrency.api.misc.blocks.ICapabilityBlock;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.common.blockentity.variant.IVariantSupportingBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityInterfaceBlockEntity
extends BlockEntity
implements IVariantSupportingBlockEntity {
    public CapabilityInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.CAPABILITY_INTERFACE.get(), pos, state);
    }

    @Override
    @Nullable
    public ResourceLocation getCurrentVariant() {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        this.tryRunOnCoreBlockEntity(be -> {
            if (be instanceof IVariantSupportingBlockEntity) {
                IVariantSupportingBlockEntity vsbe = (IVariantSupportingBlockEntity)be;
                result.set(vsbe.getCurrentVariant());
            }
        });
        return result.get();
    }

    @Override
    public void setVariant(@Nullable ResourceLocation variant) {
        this.tryRunOnCoreBlockEntity(be -> {
            if (be instanceof IVariantSupportingBlockEntity) {
                IVariantSupportingBlockEntity vsbe = (IVariantSupportingBlockEntity)be;
                vsbe.setVariant(variant);
            }
        });
    }

    @Override
    public void setVariant(@Nullable ResourceLocation variant, boolean locked) {
        this.tryRunOnCoreBlockEntity(be -> {
            if (be instanceof IVariantSupportingBlockEntity) {
                IVariantSupportingBlockEntity vsbe = (IVariantSupportingBlockEntity)be;
                vsbe.setVariant(variant, locked);
            }
        });
    }

    @Override
    public boolean isVariantLocked() {
        AtomicBoolean result = new AtomicBoolean(false);
        this.tryRunOnCoreBlockEntity(be -> {
            if (be instanceof IVariantSupportingBlockEntity) {
                IVariantSupportingBlockEntity vsbe = (IVariantSupportingBlockEntity)be;
                result.set(vsbe.isVariantLocked());
            }
        });
        return result.get();
    }

    @Nullable
    public final BlockEntity tryGetCoreBlockEntity() {
        BlockState state = this.m_58900_();
        Block block = state.m_60734_();
        if (block instanceof ICapabilityBlock) {
            ICapabilityBlock block2 = (ICapabilityBlock)block;
            BlockPos newPos = block2.getCapabilityBlockPos(state, (LevelAccessor)this.f_58857_, this.f_58858_);
            if (newPos.equals((Object)this.f_58858_)) {
                return null;
            }
            BlockEntity be = this.f_58857_.m_7702_(newPos);
            if (be instanceof CapabilityInterfaceBlockEntity) {
                return null;
            }
            return be;
        }
        return null;
    }

    public final void tryRunOnCoreBlockEntity(Consumer<BlockEntity> consumer) {
        BlockEntity be = this.tryGetCoreBlockEntity();
        if (be != null) {
            consumer.accept(be);
        }
    }

    @Nonnull
    public final <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        BlockState state = this.m_58900_();
        Block block = state.m_60734_();
        if (block instanceof ICapabilityBlock) {
            ICapabilityBlock handlerBlock = (ICapabilityBlock)block;
            BlockPos newPos = handlerBlock.getCapabilityBlockPos(state, (LevelAccessor)this.f_58857_, this.f_58858_);
            if (newPos.equals((Object)this.f_58858_)) {
                return super.getCapability(cap, side);
            }
            BlockEntity be = this.f_58857_.m_7702_(newPos);
            if (be == null || be instanceof CapabilityInterfaceBlockEntity) {
                return super.getCapability(cap, side);
            }
            return be.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        BlockState state;
        if (this.getCurrentVariant() != null && VariantProvider.getVariantBlock((state = this.m_58900_()).m_60734_()) != null && !((Boolean)state.m_61143_((Property)IVariantBlock.VARIANT)).booleanValue()) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)IVariantBlock.VARIANT, (Comparable)Boolean.valueOf(true)));
        }
        super.onLoad();
    }
}

