/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderinterface.base;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface.OwnershipClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OwnershipTab
extends TraderInterfaceTab {
    public OwnershipTab(TraderInterfaceMenu menu) {
        super(menu);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new OwnershipClientTab(screen, this);
    }

    private boolean isAdmin() {
        return ((TraderInterfaceMenu)this.menu).getBE().isOwner(((TraderInterfaceMenu)this.menu).player);
    }

    @Override
    public boolean canOpen(Player player) {
        return this.isAdmin();
    }

    public void setPlayerOwner(String newOwner) {
        if (this.isAdmin()) {
            if (((TraderInterfaceMenu)this.menu).isClient()) {
                ((TraderInterfaceMenu)this.menu).SendMessage(this.builder().setString("NewPlayerOwner", newOwner));
            } else {
                PlayerReference player = PlayerReference.of(false, newOwner);
                if (player != null) {
                    ((TraderInterfaceMenu)this.menu).getBE().owner.SetOwner(PlayerOwner.of(player));
                }
            }
        }
    }

    public void setOwner(Owner newOwner) {
        if (this.isAdmin()) {
            ((TraderInterfaceMenu)this.menu).getBE().owner.SetOwner(newOwner);
            if (((TraderInterfaceMenu)this.menu).isClient()) {
                ((TraderInterfaceMenu)this.menu).SendMessage(this.builder().setOwner("NewOwner", newOwner));
            }
        }
    }

    @Override
    public void handleMessage(@Nonnull LazyPacketData message) {
        if (message.contains("NewPlayerOwner")) {
            this.setPlayerOwner(message.getString("NewPlayerOwner"));
        }
        if (message.contains("NewOwner")) {
            this.setOwner(message.getOwner("NewOwner"));
        }
    }
}

