/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.terminal.filters;

import io.github.lightman314.lightmanscurrency.api.traders.terminal.IBasicTraderFilter;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.PendingSearch;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.trade_data.SlotMachineTrade;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.ItemTraderSearchFilter;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;

public class SlotMachineSearchFilter
implements IBasicTraderFilter {
    @Override
    public void filterTrade(@Nonnull TradeData data, @Nonnull PendingSearch search) {
        if (data instanceof SlotMachineTrade) {
            SlotMachineTrade trade = (SlotMachineTrade)data;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (SlotMachineEntry entry : trade.trader.getValidEntries()) {
                if (!entry.isValid()) continue;
                items.addAll(entry.items);
            }
            search.processFilter("item", ItemTraderSearchFilter.filterItems(items));
            search.processFilter("tooltip", ItemTraderSearchFilter.filterItemTooltips(items));
        }
    }
}

