/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.QuarantineAPI;
import io.github.lightman314.lightmanscurrency.common.items.PortableATMItem;
import io.github.lightman314.lightmanscurrency.common.menus.validation.EasyMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.ItemValidator;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CPacketOpenATM
extends ClientToServerPacket {
    public static CustomPacket.Handler<CPacketOpenATM> HANDLER = new H();
    private final Item portableATM;

    public CPacketOpenATM(Item portableATM) {
        this.portableATM = portableATM;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(ForgeRegistries.ITEMS.getKey((Object)this.portableATM));
    }

    private static class H
    extends CustomPacket.Handler<CPacketOpenATM> {
        private H() {
        }

        @Override
        public CPacketOpenATM decode(FriendlyByteBuf buffer) {
            return new CPacketOpenATM((Item)ForgeRegistries.ITEMS.getValue(buffer.m_130281_()));
        }

        @Override
        public void handle(CPacketOpenATM message, Player player) {
            if (QuarantineAPI.IsDimensionQuarantined((Entity)player)) {
                EasyText.sendMessage(player, (Component)LCText.MESSAGE_DIMENSION_QUARANTINED_BANK.getWithStyle(ChatFormatting.GOLD));
            } else if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)PortableATMItem.getMenuProvider(message.portableATM), EasyMenu.encoder(new ItemValidator((ItemLike)message.portableATM)));
            }
        }
    }
}

