/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.config.ConfigAPI;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.ConfigReloadable;
import io.github.lightman314.lightmanscurrency.api.misc.BlockProtectionHelper;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.BankAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.TeamBankReference;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.types.builtin.CoinCurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.types.builtin.NullCurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyViewer;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.OwnershipAPI;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.FakeOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.TeamOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.listing.builtin.PlayerOwnerProvider;
import io.github.lightman314.lightmanscurrency.api.ownership.listing.builtin.TeamOwnerProvider;
import io.github.lightman314.lightmanscurrency.api.settings.pretty.PrettyTextWriter;
import io.github.lightman314.lightmanscurrency.api.settings.pretty.builtin.BookTextWriter;
import io.github.lightman314.lightmanscurrency.api.stats.StatType;
import io.github.lightman314.lightmanscurrency.api.stats.types.IntegerStat;
import io.github.lightman314.lightmanscurrency.api.stats.types.MultiMoneyStat;
import io.github.lightman314.lightmanscurrency.api.taxes.TaxAPI;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.TaxesCollectedNotification;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.TaxesPaidNotification;
import io.github.lightman314.lightmanscurrency.api.taxes.reference.builtin.TaxableTraderReference;
import io.github.lightman314.lightmanscurrency.api.ticket.TicketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.types.SortByID;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.types.SortByName;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.types.SortByOffers;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.types.SortByPopularity;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.types.SortByRecent;
import io.github.lightman314.lightmanscurrency.common.advancements.LCAdvancementTriggers;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinBlock;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModRegistries;
import io.github.lightman314.lightmanscurrency.common.crafting.condition.LCCraftingConditions;
import io.github.lightman314.lightmanscurrency.common.data.types.TraderDataCache;
import io.github.lightman314.lightmanscurrency.common.gamerule.ModGameRules;
import io.github.lightman314.lightmanscurrency.common.loot.LootManager;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidatorType;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockEntityValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.EntityValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.ItemValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.common.money.ancient_money.AncientCoinSorter;
import io.github.lightman314.lightmanscurrency.common.money.ancient_money.AncientMoneyType;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.AuctionHouseCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.EventCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TaxEntryCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.types.TextNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBuyerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseCancelNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNobidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.BankInterestNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.BankTransferNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.DepositWithdrawNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.LowBalanceNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.ejection.OwnableBlockEjectedNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.AddRemoveAllyNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.AddRemoveTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeAllyPermissionNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeCreativeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeNameNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeOwnerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeSettingNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.CommandTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.GachaTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.ItemTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.OutOfStockNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.PaygateNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.SlotMachineTradeNotification;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.seasonal_events.SeasonalEventManager;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.commands.CommandTrader;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaTrader;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataArmor;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataBook;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataTicket;
import io.github.lightman314.lightmanscurrency.common.traders.item.ticket.TicketItemTrade;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.DailyTrades;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.DemandPricing;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.DiscountCodes;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.FreeSample;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerDiscounts;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerListing;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerTradeLimit;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PriceFluctuation;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.TimedSale;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.TradeLimit;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.AuctionSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.BasicSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.DescriptionSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.ItemTraderSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.SlotMachineSearchFilter;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.ItemListingSerializer;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.VillagerTradeManager;
import io.github.lightman314.lightmanscurrency.integration.IntegrationUtil;
import io.github.lightman314.lightmanscurrency.integration.biomesoplenty.BOPCustomWoodTypes;
import io.github.lightman314.lightmanscurrency.integration.bwg.BWGCustomWoodTypes;
import io.github.lightman314.lightmanscurrency.integration.claiming.cadmus.LCCadmusIntegration;
import io.github.lightman314.lightmanscurrency.integration.claiming.flan.LCFlanIntegration;
import io.github.lightman314.lightmanscurrency.integration.claiming.ftbchunks.LCFTBChunksIntegration;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCComputercraftSetup;
import io.github.lightman314.lightmanscurrency.integration.create.LCCreate;
import io.github.lightman314.lightmanscurrency.integration.discord.LCDiscord;
import io.github.lightman314.lightmanscurrency.integration.ftbteams.LCFTBTeams;
import io.github.lightman314.lightmanscurrency.integration.immersiveengineering.LCImmersive;
import io.github.lightman314.lightmanscurrency.integration.impactor.LCImpactorCompat;
import io.github.lightman314.lightmanscurrency.integration.quark.QuarkCustomWoodTypes;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.time.SPacketSyncTime;
import io.github.lightman314.lightmanscurrency.proxy.ClientProxy;
import io.github.lightman314.lightmanscurrency.proxy.CommonProxy;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lightmanscurrency")
public class LightmansCurrency {
    public static final String MODID = "lightmanscurrency";
    private static final CommonProxy PROXY = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static final Logger LOGGER = LogManager.getLogger();

    @Nonnull
    public static CommonProxy getProxy() {
        return PROXY;
    }

    public LightmansCurrency() {
        LootManager.registerDroplistListeners();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerCapabilities);
        LCConfig.init();
        LootManager.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        IntegrationUtil.SafeRunIfLoaded("biomesoplenty", BOPCustomWoodTypes::setupWoodTypes, "Error setting up BOP wood types! BOP has probably changed their API!");
        IntegrationUtil.SafeRunIfLoaded("quark", QuarkCustomWoodTypes::setupWoodTypes, "Error setting up Quark wood types! Quark has probably changed their API!");
        IntegrationUtil.SafeRunIfLoaded("biomeswevegone", BWGCustomWoodTypes::setupWoodTypes, "Error setting up BWG wood types! BWG has probably changed their API!");
        ModRegistries.register(FMLJavaModLoadingContext.get().getModEventBus());
        LightmansCurrency.getProxy().init();
        IntegrationUtil.SafeRunIfLoaded("lightmansdiscord", LCDiscord::setup, null);
        IntegrationUtil.SafeRunIfLoaded("ftbchunks", LCFTBChunksIntegration::setup, "Error setting up FTB Chunks chunk purchasing integration!");
        IntegrationUtil.SafeRunIfLoaded("flan", LCFlanIntegration::setup, "Error setting up Flans chunk purchasing integration!");
        IntegrationUtil.SafeRunIfLoaded("immersiveengineering", LCImmersive::registerRotationBlacklists, null);
        IntegrationUtil.SafeRunIfLoaded("create", LCCreate::init, "Error settings up Create Integration!");
        IntegrationUtil.SafeRunIfLoaded("computercraft", LCComputercraftSetup::setup, "Error settings up ComputerCraft Integration!");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LightmansCurrency.safeEnqueueWork(event, "Error during common setup!", this::commonSetupWork);
    }

    private void commonSetupWork(FMLCommonSetupEvent event) {
        ConfigFile.loadServerFiles(ConfigFile.LoadPhase.SETUP);
        IntegrationUtil.SafeRunIfLoaded("impactor", LCImpactorCompat::setup, "Error setting up Impactor Economy Compatibility");
        IntegrationUtil.SafeRunIfLoaded("cadmus", LCCadmusIntegration::setup, null);
        CoinAPI.getApi().Setup();
        MoneyAPI.getApi().RegisterCurrencyType(CoinCurrencyType.INSTANCE);
        MoneyAPI.getApi().RegisterCurrencyType(NullCurrencyType.INSTANCE);
        MoneyAPI.getApi().RegisterCurrencyType(AncientMoneyType.INSTANCE);
        CoinAPI.getApi().RegisterCustomSorter(AncientCoinSorter.INSTANCE);
        LightmansCurrencyPacketHandler.init();
        LCCraftingConditions.register();
        OwnershipAPI.getApi().registerOwnerType(Owner.NULL_TYPE);
        OwnershipAPI.getApi().registerOwnerType(FakeOwner.TYPE);
        OwnershipAPI.getApi().registerOwnerType(PlayerOwner.TYPE);
        OwnershipAPI.getApi().registerOwnerType(TeamOwner.TYPE);
        OwnershipAPI.getApi().registerPotentialOwnerProvider(PlayerOwnerProvider.INSTANCE);
        OwnershipAPI.getApi().registerPotentialOwnerProvider(TeamOwnerProvider.INSTANCE);
        TraderAPI.getApi().RegisterTrader(ItemTraderData.TYPE);
        TraderAPI.getApi().RegisterTrader(ItemTraderDataArmor.TYPE);
        TraderAPI.getApi().RegisterTrader(ItemTraderDataTicket.TYPE);
        TraderAPI.getApi().RegisterTrader(ItemTraderDataBook.TYPE);
        TraderAPI.getApi().RegisterTrader(SlotMachineTraderData.TYPE);
        TraderAPI.getApi().RegisterTrader(PaygateTraderData.TYPE);
        TraderAPI.getApi().RegisterTrader(AuctionHouseTrader.TYPE);
        TraderAPI.getApi().RegisterTrader(CommandTrader.TYPE);
        TraderAPI.getApi().RegisterTrader(GachaTrader.TYPE);
        ModGameRules.registerRules();
        TraderAPI.getApi().RegisterTradeRule(PlayerListing.TYPE);
        TraderAPI.getApi().RegisterTradeRule(PlayerTradeLimit.TYPE);
        TraderAPI.getApi().RegisterTradeRule(PlayerDiscounts.TYPE);
        TraderAPI.getApi().RegisterTradeRule(TimedSale.TYPE);
        TraderAPI.getApi().RegisterTradeRule(TradeLimit.TYPE);
        TraderAPI.getApi().RegisterTradeRule(FreeSample.TYPE);
        TraderAPI.getApi().RegisterTradeRule(PriceFluctuation.TYPE);
        TraderAPI.getApi().RegisterTradeRule(DemandPricing.TYPE);
        TraderAPI.getApi().RegisterTradeRule(DailyTrades.TYPE);
        TraderAPI.getApi().RegisterTradeRule(DiscountCodes.TYPE);
        TradeRule.addLoadListener(PlayerListing.LISTENER);
        TradeRule.addIgnoreMissing("lightmanscurrency:whitelist");
        TradeRule.addIgnoreMissing("lightmanscurrency:blacklist");
        NotificationAPI.getApi().RegisterNotification(ItemTradeNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(PaygateNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(SlotMachineTradeNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(OutOfStockNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(LowBalanceNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(AuctionHouseSellerNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(AuctionHouseBuyerNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(AuctionHouseSellerNobidNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(AuctionHouseBidNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(AuctionHouseCancelNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(TextNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(AddRemoveAllyNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(AddRemoveTradeNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(ChangeAllyPermissionNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(ChangeCreativeNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(ChangeNameNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(ChangeOwnerNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(ChangeSettingNotification.SIMPLE_TYPE);
        NotificationAPI.getApi().RegisterNotification(ChangeSettingNotification.ADVANCED_TYPE);
        NotificationAPI.getApi().RegisterNotification(ChangeSettingNotification.DUMB_TYPE);
        NotificationAPI.getApi().RegisterNotification(DepositWithdrawNotification.PLAYER_TYPE);
        NotificationAPI.getApi().RegisterNotification(DepositWithdrawNotification.CUSTOM_TYPE);
        NotificationAPI.getApi().RegisterNotification(DepositWithdrawNotification.SERVER_TYPE);
        NotificationAPI.getApi().RegisterNotification(BankTransferNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(BankInterestNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(TaxesCollectedNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(TaxesPaidNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(OwnableBlockEjectedNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(CommandTradeNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(GachaTradeNotification.TYPE);
        NotificationAPI.getApi().RegisterCategory(NotificationCategory.GENERAL_TYPE);
        NotificationAPI.getApi().RegisterCategory(NullCategory.TYPE);
        NotificationAPI.getApi().RegisterCategory(EventCategory.TYPE);
        NotificationAPI.getApi().RegisterCategory(TraderCategory.TYPE);
        NotificationAPI.getApi().RegisterCategory(BankCategory.TYPE);
        NotificationAPI.getApi().RegisterCategory(AuctionHouseCategory.TYPE);
        NotificationAPI.getApi().RegisterCategory(TaxEntryCategory.TYPE);
        TraderAPI.getApi().RegisterTraderSearchFilter(new BasicSearchFilter());
        TraderAPI.getApi().RegisterSearchFilter(new ItemTraderSearchFilter());
        TraderAPI.getApi().RegisterSearchFilter(new SlotMachineSearchFilter());
        TraderAPI.getApi().RegisterSearchFilter(new AuctionSearchFilter());
        TraderAPI.getApi().RegisterSearchFilter(new DescriptionSearchFilter());
        TraderAPI.getApi().RegisterSortType(SortByName.INSTANCE);
        TraderAPI.getApi().RegisterSortType(SortByID.INSTANCE);
        TraderAPI.getApi().RegisterSortType(SortByOffers.INSTANCE);
        TraderAPI.getApi().RegisterSortType(SortByPopularity.INSTANCE);
        TraderAPI.getApi().RegisterSortType(SortByRecent.INSTANCE);
        TaxAPI.getApi().RegisterReferenceType(TaxableTraderReference.TYPE);
        BankAPI.getApi().RegisterReferenceType(PlayerBankReference.TYPE);
        BankAPI.getApi().RegisterReferenceType(TeamBankReference.TYPE);
        MenuValidatorType.register(SimpleValidator.TYPE);
        MenuValidatorType.register(BlockEntityValidator.TYPE);
        MenuValidatorType.register(BlockValidator.TYPE);
        MenuValidatorType.register(EntityValidator.TYPE);
        MenuValidatorType.register(ItemValidator.TYPE);
        ItemTradeRestriction.init();
        TicketData.create((ItemLike)ModItems.TICKET_MASTER.get(), (ItemLike)ModItems.TICKET.get(), (ItemLike)ModItems.TICKET_STUB.get(), LCTags.Items.TICKET_MATERIAL_PAPER);
        TicketData.create((ItemLike)ModItems.GOLDEN_TICKET_MASTER.get(), (ItemLike)ModItems.GOLDEN_TICKET.get(), (ItemLike)ModItems.GOLDEN_TICKET_STUB.get(), LCTags.Items.TICKET_MATERIAL_GOLD);
        ItemListingSerializer.registerDefaultSerializers();
        VillagerTradeManager.registerDefaultTrades();
        IconData.registerDefaultIcons();
        StatType.register(IntegerStat.INSTANCE);
        StatType.register(MultiMoneyStat.INSTANCE);
        LCAdvancementTriggers.setup();
        BlockProtectionHelper.ProtectBlock(b -> b instanceof IOwnableBlock);
        BlockProtectionHelper.ProtectBlock(b -> b instanceof CoinBlock);
        PrettyTextWriter.register(BookTextWriter.INSTANCE);
        ItemTradeData.registerCustomItemTrade(TicketItemTrade.TYPE, TicketItemTrade::new);
        ConfigAPI.getApi().registerCustomReloadable(ConfigReloadable.simpleReloader(VersionUtil.lcResource("master_coin_list"), 100, stack -> CoinAPI.getApi().ReloadCoinDataFromFile()));
        ConfigAPI.getApi().registerCustomReloadable(ConfigReloadable.simpleReloader(VersionUtil.lcResource("persistent_traders"), 1000, stack -> TraderDataCache.TYPE.get(false).reloadPersistentTraders()));
        ConfigAPI.getApi().registerCustomReloadable(ConfigReloadable.simpleReloader(VersionUtil.lcResource("seasonal_events"), stack -> SeasonalEventManager.reload()));
        IntegrationUtil.SafeRunIfLoaded("ftbteams", LCFTBTeams::setup, "Error setting up FTB Teams compat!");
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LightmansCurrency.safeEnqueueWork((ParallelDispatchEvent)event, "Error during client setup!", LightmansCurrency.getProxy()::setupClient);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IWalletHandler.class);
        event.register(IMoneyHandler.class);
        event.register(IMoneyViewer.class);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PacketDistributor.PacketTarget target = LightmansCurrencyPacketHandler.getTarget(event.getEntity());
        SPacketSyncTime.syncWith(target);
        LCAdminMode.sendSyncPacket(target);
    }

    public static void LogDebug(String message) {
        LOGGER.debug(message);
    }

    public static void LogDebug(String message, Object ... objects) {
        LOGGER.debug(message, objects);
    }

    public static void LogInfo(String message) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 0) {
            LOGGER.debug("INFO: " + message);
        } else {
            LOGGER.info(message);
        }
    }

    public static void LogInfo(String message, Object ... objects) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 0) {
            LOGGER.debug("INFO: " + message, objects);
        } else {
            LOGGER.info(message, objects);
        }
    }

    public static void LogWarning(String message) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 1) {
            LOGGER.debug("WARN: " + message);
        } else {
            LOGGER.warn(message);
        }
    }

    public static void LogWarning(String message, Object ... objects) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 1) {
            LOGGER.debug("WARN: " + message, objects);
        } else {
            LOGGER.warn(message, objects);
        }
    }

    public static void LogError(String message) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 2) {
            LOGGER.debug("ERROR: " + message);
        } else {
            LOGGER.error(message);
        }
    }

    public static void LogError(String message, Object ... objects) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 2) {
            LOGGER.debug("ERROR: " + message, objects);
        } else {
            LOGGER.error(message, objects);
        }
    }

    public static void safeEnqueueWork(ParallelDispatchEvent event, String errorMessage, Runnable work) {
        event.enqueueWork(() -> {
            try {
                work.run();
            }
            catch (Throwable t) {
                LightmansCurrency.LogError(errorMessage, t);
            }
        });
    }

    public static <T extends ParallelDispatchEvent> void safeEnqueueWork(T event, String errorMessage, Consumer<T> work) {
        event.enqueueWork(() -> {
            try {
                work.accept(event);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError(errorMessage, t);
            }
        });
    }
}

