/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.ConfigComments;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.common.text.MultiLineTextEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class ConfigOption<T>
implements Supplier<T> {
    private final List<Consumer<ConfigOption<?>>> listeners = new ArrayList();
    private ConfigComments comments = ConfigComments.EMPTY;
    private ConfigFile parent = null;
    private String name = "null";
    private String optionID = "null.null";
    private final Supplier<T> defaultValue;
    private T currentValue = null;
    private T syncedValue = null;

    public void addListener(Consumer<ConfigOption<?>> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Consumer<ConfigOption<?>> listener) {
        this.listeners.remove(listener);
    }

    public final void setComments(ConfigComments comments) {
        if (this.comments == ConfigComments.EMPTY) {
            this.comments = comments;
        } else {
            LightmansCurrency.LogWarning("Attempted to define an options comments twice!");
        }
    }

    @Nullable
    public final ConfigFile getFile() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getFullName() {
        ConfigFile file = this.getFile();
        if (file == null) {
            return null;
        }
        for (Map.Entry<String, ConfigOption<?>> entry : file.getAllOptions().entrySet()) {
            if (entry.getValue() != this) continue;
            return entry.getKey();
        }
        return null;
    }

    public final void init(ConfigFile parent, String name, String optionID) {
        if (this.parent == null) {
            this.parent = parent;
            this.name = name;
            this.optionID = optionID;
        } else {
            LightmansCurrency.LogWarning("Attempted to define an options parent twice!");
        }
    }

    public final List<String> getComments() {
        List<String> list = this.comments.getComments();
        list.addAll(this.bonusComments());
        return list;
    }

    public Component getDisplayName() {
        return EasyText.translatable(ConfigFile.translationForOption(this.parent.getFileID(), this.getFullName()), new Object[0]);
    }

    public List<Component> getCommentTooltips() {
        List<Component> list = new MultiLineTextEntry(ConfigFile.translationForComment(this.parent.getFileID(), this.getFullName())).get(new Object[0]);
        list.addAll(this.bonusCommentTooltips());
        return list;
    }

    protected ConfigOption(Supplier<T> defaultValue) {
        this.defaultValue = defaultValue;
    }

    protected List<String> bonusComments() {
        String bonus = this.bonusComment();
        if (bonus == null) {
            return new ArrayList<String>();
        }
        return Lists.newArrayList((Object[])new String[]{bonus});
    }

    @Nullable
    protected String bonusComment() {
        return null;
    }

    protected List<Component> bonusCommentTooltips() {
        Component bonus = this.bonusCommentTooltip();
        if (bonus == null) {
            return new ArrayList<Component>();
        }
        return Lists.newArrayList((Object[])new Component[]{bonus});
    }

    @Nullable
    protected Component bonusCommentTooltip() {
        return null;
    }

    protected abstract ConfigParser<T> getParser();

    private void alertListeners(boolean includingFile) {
        if (includingFile && this.parent != null) {
            this.parent.onOptionChanged(this);
        }
        for (Consumer<ConfigOption<?>> l : new ArrayList(this.listeners)) {
            l.accept(this);
        }
    }

    @Nullable
    public final Pair<Boolean, ConfigParsingException> load(String line, LoadSource source) {
        line = ConfigOption.cleanWhitespace(line);
        try {
            T val = this.getParser().tryParse(line);
            if (source == LoadSource.SYNC) {
                this.syncedValue = val;
            } else {
                this.currentValue = val;
            }
            if (source == LoadSource.COMMAND && this.parent != null) {
                this.parent.onOptionChanged(this);
            }
            if (source == LoadSource.SYNC) {
                this.alertListeners(false);
            }
            return Pair.of((Object)true, null);
        }
        catch (ConfigParsingException e) {
            LightmansCurrency.LogError("Error parsing " + this.optionID + "!", e);
            this.currentValue = this.defaultValue.get();
            return Pair.of((Object)false, (Object)e);
        }
    }

    public final void clear() {
        this.currentValue = null;
    }

    public final boolean isLoaded() {
        return this.currentValue != null;
    }

    public final void setToDefault() {
        this.set(this.getDefaultValue());
    }

    public final void loadDefault() {
        this.currentValue = this.getDefaultValue();
    }

    public final void clearSyncedData() {
        this.syncedValue = null;
    }

    public final String write() {
        return this.getParser().write(this.getCurrentValue());
    }

    public final void write(String name, Consumer<String> writer) {
        ConfigFile.writeComments(this.getComments(), writer);
        writer.accept(name + "=" + this.write());
    }

    @Nullable
    public final String writeUnsafe(Object object) {
        try {
            return this.getParser().write(object);
        }
        catch (ClassCastException ignored) {
            return null;
        }
    }

    public static String cleanWhitespace(String line) {
        StringBuilder result = new StringBuilder();
        boolean start = true;
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c)) {
                if (start) continue;
                temp.append(c);
                continue;
            }
            if (start) {
                start = false;
            }
            if (!temp.isEmpty()) {
                result.append((CharSequence)temp);
                temp = new StringBuilder();
            }
            result.append(c);
        }
        return result.toString();
    }

    @Override
    public final T get() {
        if (this.syncedValue != null) {
            return this.syncedValue;
        }
        return this.getCurrentValue();
    }

    public void set(T newValue) {
        if (this.currentValue != null && this.isSame(newValue, this.currentValue)) {
            return;
        }
        if (!this.allowedValue(newValue)) {
            return;
        }
        this.currentValue = Objects.requireNonNull(newValue);
        this.alertListeners(true);
    }

    public boolean allowedValue(T newValue) {
        return true;
    }

    public void setUnsafe(Object newValue) {
        T oldValue = this.get();
        boolean synced = this.syncedValue != null;
        try {
            Object nv = newValue;
            if (nv == null || this.isSame(nv, oldValue)) {
                return;
            }
            if (!this.allowedValue(nv)) {
                return;
            }
            if (synced) {
                this.syncedValue = nv;
            } else {
                this.currentValue = nv;
            }
            this.get();
            this.alertListeners(!synced);
        }
        catch (ClassCastException e) {
            LightmansCurrency.LogDebug("SetUnsafe operation failed!", e);
            if (synced) {
                this.syncedValue = oldValue;
            }
            this.set(oldValue);
        }
    }

    protected final boolean isSame(T newValue, T currentValue) {
        ConfigParser<T> parser = this.getParser();
        return Objects.equals(parser.write(Objects.requireNonNull(newValue)), parser.write(currentValue));
    }

    protected final T getCurrentValue() {
        if (this.currentValue == null) {
            LightmansCurrency.LogDebug("Attempted to access the value of '" + this.optionID + "' before the config was loaded!");
            return this.getDefaultValue();
        }
        return this.currentValue;
    }

    public T getDefaultValue() {
        return this.defaultValue.get();
    }

    public static enum LoadSource {
        FILE,
        COMMAND,
        SYNC;

    }
}

