/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.data.variables.permissions;

import io.github.lightman314.lightmanscurrency.api.misc.data.variables.IVariableHost;
import io.github.lightman314.lightmanscurrency.api.misc.data.variables.permissions.CombinedPermission;
import io.github.lightman314.lightmanscurrency.api.misc.data.variables.permissions.LeveledPermissions;
import io.github.lightman314.lightmanscurrency.api.misc.data.variables.permissions.OwnerPermissions;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.player.Player;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IVariablePermission {
    public boolean canEdit(Player var1, IVariableHost var2);

    default public IVariablePermission and(IVariablePermission other) {
        return CombinedPermission.and(this, other);
    }

    default public IVariablePermission or(IVariablePermission other) {
        return CombinedPermission.or(this, other);
    }

    public static IVariablePermission noTest() {
        return (player, host) -> true;
    }

    public static IVariablePermission membersOnly() {
        return OwnerPermissions.MEMBER;
    }

    public static IVariablePermission adminsOnly() {
        return OwnerPermissions.ADMIN;
    }

    public static IVariablePermission hasPermission(String permission) {
        return LeveledPermissions.hasPermission(permission);
    }

    public static IVariablePermission minPermission(String permission, int minLevel) {
        return LeveledPermissions.minPermission(permission, minLevel);
    }

    public static IVariablePermission exactPermission(String permission, int exactLevel) {
        return LeveledPermissions.exactPermission(permission, exactLevel);
    }
}

