/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.icons;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconIcon;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ImageIcon;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.misc.icons.MultiIcon;
import io.github.lightman314.lightmanscurrency.api.misc.icons.NumberIcon;
import io.github.lightman314.lightmanscurrency.api.misc.icons.TextIcon;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class IconData {
    private static IconData NULL = null;
    private static final Map<ResourceLocation, Type> ICON_TYPES = new HashMap<ResourceLocation, Type>();
    protected final Type type;

    public static IconData Null() {
        if (NULL == null) {
            NULL = new NullIcon();
        }
        return NULL;
    }

    public static void registerIconType(Type type) {
        if (ICON_TYPES.containsKey(type.id)) {
            LightmansCurrency.LogDebug("Attempted to register icon of type '" + type + "' twice!");
            return;
        }
        ICON_TYPES.put(type.id, type);
    }

    public static void registerDefaultIcons() {
        if (ICON_TYPES.containsKey(NullIcon.TYPE.id)) {
            LightmansCurrency.LogWarning("Attempted to register the default icons twice!");
            return;
        }
        IconData.registerIconType(NullIcon.TYPE);
        IconData.registerIconType(ItemIcon.TYPE);
        IconData.registerIconType(ImageIcon.TYPE);
        IconData.registerIconType(IconIcon.TYPE);
        IconData.registerIconType(TextIcon.TYPE);
        IconData.registerIconType(NumberIcon.TYPE);
        IconData.registerIconType(MultiIcon.TYPE);
    }

    @Nullable
    public static IconData load(CompoundTag tag) {
        ResourceLocation type;
        if (tag.m_128441_("Type") && ICON_TYPES.containsKey(type = VersionUtil.parseResource(tag.m_128461_("Type")))) {
            return IconData.ICON_TYPES.get((Object)type).loader.apply(tag);
        }
        return null;
    }

    public static IconData safeLoad(CompoundTag tag, IconData defaultIcon) {
        return Objects.requireNonNullElse(IconData.load(tag), defaultIcon);
    }

    public static IconData parse(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        ResourceLocation type = VersionUtil.parseResource(GsonHelper.m_13906_((JsonObject)json, (String)"Type"));
        if (ICON_TYPES.containsKey(type)) {
            return IconData.ICON_TYPES.get((Object)type).parser.apply(json);
        }
        throw new JsonSyntaxException("Unknown icon type " + type);
    }

    public final boolean isNull() {
        return this instanceof NullIcon;
    }

    protected IconData(Type type) {
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void render(EasyGuiGraphics gui, ScreenPosition pos) {
        this.render(gui, pos.x, pos.y);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void render(EasyGuiGraphics var1, int var2, int var3);

    public final CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        tag.m_128359_("Type", this.type.toString());
        return tag;
    }

    protected abstract void saveAdditional(CompoundTag var1);

    public final JsonObject write() {
        JsonObject json = new JsonObject();
        this.writeAdditional(json);
        json.addProperty("Type", this.type.toString());
        return json;
    }

    protected abstract void writeAdditional(JsonObject var1);

    private static class NullIcon
    extends IconData {
        private static final Type TYPE = new Type(VersionUtil.lcResource("null"), c -> IconData.Null(), c -> IconData.Null());

        private NullIcon() {
            super(TYPE);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(EasyGuiGraphics gui, int x, int y) {
        }

        @Override
        protected void saveAdditional(CompoundTag tag) {
        }

        @Override
        protected void writeAdditional(JsonObject json) {
        }
    }

    public record Type(ResourceLocation id, Function<CompoundTag, IconData> loader, Function<JsonObject, IconData> parser) {
        @Override
        public String toString() {
            return this.id.toString();
        }
    }
}

