/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.stats.types;

import io.github.lightman314.lightmanscurrency.api.stats.StatType;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class IntegerStat
extends StatType<Integer, Integer> {
    public static final ResourceLocation TYPE = VersionUtil.lcResource("basic_int");
    public static final StatType<Integer, Integer> INSTANCE = new IntegerStat();

    @Override
    @Nonnull
    public StatType.Instance<Integer, Integer> create() {
        return new IntInstance();
    }

    @Override
    @Nonnull
    public ResourceLocation getID() {
        return TYPE;
    }

    private IntegerStat() {
    }

    protected static class IntInstance
    extends StatType.Instance<Integer, Integer> {
        private int value = 0;

        protected IntInstance() {
        }

        @Override
        @Nonnull
        protected StatType<Integer, Integer> getType() {
            return INSTANCE;
        }

        @Override
        protected void saveAdditional(@Nonnull CompoundTag tag) {
            tag.m_128405_("Value", this.value);
        }

        @Override
        public void load(@Nonnull CompoundTag tag) {
            this.value = tag.m_128451_("Value");
        }

        @Override
        public Integer get() {
            return this.value;
        }

        @Override
        protected void addInternal(@Nonnull Integer addAmount) {
            this.value += addAmount.intValue();
        }

        @Override
        public void clear() {
            this.value = 0;
        }

        @Override
        public Object getDisplay() {
            return this.value;
        }
    }
}

