/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.common;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.traders.ITraderSource;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.TraderClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketExecuteTrade;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.inventory.Slot;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TraderInteractionTab
extends TraderClientTab {
    TradeButtonArea tradeDisplay;
    private static long lastPress = 0L;

    public TraderInteractionTab(TraderScreen screen) {
        super(screen);
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.tradeDisplay != null && this.tradeDisplay.isSearchBoxRelevant();
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.tradeDisplay = this.addChild(((TradeButtonArea.Builder)((TradeButtonArea.Builder)TradeButtonArea.builder().position(screenArea.pos.offset(3, 17))).size(screenArea.width - 6, 89)).traderSource(this.menu::getTraderSource).context(this.menu::getContext).pressAction(this::OnButtonPress).tradeFilter(TradeData::isValid).title(screenArea.pos.offset(4, 6), screenArea.width - 8, true).build());
    }

    @Override
    public void renderBG(EasyGuiGraphics gui) {
        TradeButton hoveredButton = this.tradeDisplay.getHoveredButton(gui.mousePos);
        if (hoveredButton != null) {
            gui.resetColor();
            TradeData trade = hoveredButton.getTrade();
            TradeContext context = hoveredButton.getContext();
            List<Integer> relevantSlots = trade.getRelevantInventorySlots(context, this.menu.getSlots());
            for (int s : relevantSlots) {
                if (s < 0 || s >= this.menu.getSlots().size()) continue;
                Slot slot = this.menu.getSlots().get(s);
                gui.renderSlot(this.screen, slot.f_40220_, slot.f_40221_, SpriteUtil.EMPTY_SLOT_YELLOW);
            }
        }
    }

    private void OnButtonPress(TraderData trader, TradeData trade) {
        if (trader == null || trade == null) {
            return;
        }
        if (TimeUtil.compareTime(10L, lastPress)) {
            return;
        }
        lastPress = TimeUtil.getCurrentTime();
        ITraderSource ts = this.menu.getTraderSource();
        if (ts == null) {
            this.menu.getPlayer().m_6915_();
            return;
        }
        List<TraderData> traders = ts.getTraders();
        int ti = traders.indexOf(trader);
        if (ti < 0) {
            return;
        }
        TraderData t = traders.get(ti);
        if (t == null) {
            return;
        }
        int tradeIndex = t.getTradeData().indexOf(trade);
        if (tradeIndex < 0) {
            return;
        }
        new CPacketExecuteTrade(ti, tradeIndex).send();
    }
}

