/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

public class TeamSelectWidget
extends EasyWidgetWithChildren {
    private final int rows;
    private final Supplier<List<ITeam>> teamSource;
    private final Supplier<ITeam> selectedTeam;
    private final Consumer<Integer> onPress;
    private final List<TeamButton> teamButtons = new ArrayList<TeamButton>();
    private int scroll = 0;

    private TeamSelectWidget(@Nonnull Builder builder) {
        super(builder);
        this.rows = builder.rows;
        this.teamSource = builder.teams;
        this.selectedTeam = builder.selected;
        this.onPress = builder.handler;
    }

    @Override
    public void addChildren(@Nonnull ScreenArea area) {
        this.teamButtons.clear();
        for (int i = 0; i < this.rows; ++i) {
            int index = i;
            TeamButton button = this.addChild(((TeamButton.Builder)((TeamButton.Builder)TeamButton.builder().position(area.pos.offset(0, i * 20))).width(this.f_93618_).pressAction(this::onTeamSelect)).team(() -> this.getTeam(index)).selected(() -> this.isSelected(index)).build());
            this.teamButtons.add(button);
        }
    }

    @Override
    protected void renderTick() {
        for (TeamButton b : this.teamButtons) {
            b.setVisible(this.f_93624_);
        }
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        this.teamButtons.forEach(b -> {
            b.f_93624_ = this.f_93624_;
        });
        if (!this.f_93624_) {
            return;
        }
        gui.fill(this.getArea().atPosition(ScreenPosition.ZERO), -16777216);
    }

    private ITeam getTeam(int index) {
        List<ITeam> teamList = this.teamSource.get();
        this.validateScroll(teamList.size());
        if ((index += this.scroll) >= 0 && index < teamList.size()) {
            return teamList.get(index);
        }
        return null;
    }

    private boolean isSelected(int index) {
        ITeam team = this.getTeam(index);
        if (team == null) {
            return false;
        }
        return team == this.selectedTeam.get();
    }

    private void validateScroll(int teamListSize) {
        this.scroll = MathUtil.clamp(this.scroll, 0, this.maxScroll(teamListSize));
    }

    private int maxScroll(int teamListSize) {
        return MathUtil.clamp(teamListSize - this.rows, 0, Integer.MAX_VALUE);
    }

    private boolean canScrollDown() {
        return this.scroll < this.maxScroll(this.teamSource.get().size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.f_93624_) {
            return false;
        }
        if (delta < 0.0) {
            if (!this.canScrollDown()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    private void onTeamSelect(EasyButton button) {
        int index = -1;
        if (button instanceof TeamButton) {
            index = this.teamButtons.indexOf((Object)button);
        }
        if (index < 0) {
            return;
        }
        this.onPress.accept(this.scroll + index);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyWidget.EasyBuilder<Builder> {
        private int rows = 1;
        private Supplier<List<ITeam>> teams = ArrayList::new;
        private Supplier<ITeam> selected = () -> null;
        private Consumer<Integer> handler = i -> {};

        private Builder() {
            super(156, 20);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder width(int width) {
            this.changeWidth(width);
            return this;
        }

        public Builder rows(int rows) {
            this.rows = rows;
            this.changeHeight(rows * 20);
            return this;
        }

        public Builder teams(Supplier<List<ITeam>> teams) {
            this.teams = teams;
            return this;
        }

        public Builder selected(Supplier<ITeam> selected) {
            this.selected = selected;
            return this;
        }

        public Builder handler(Consumer<Integer> handler) {
            this.handler = handler;
            return this;
        }

        public TeamSelectWidget build() {
            return new TeamSelectWidget(this);
        }
    }
}

