/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyValueWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

public class TimeInputWidget
extends EasyWidgetWithChildren {
    private final List<TimeUtil.TimeUnit> relevantUnits;
    private final int spacing;
    public long maxDuration = Long.MAX_VALUE;
    public long minDuration = 0L;
    private final Consumer<TimeUtil.TimeData> timeConsumer;
    long days = 0L;
    long hours = 0L;
    long minutes = 0L;
    long seconds = 0L;
    private final List<EasyButton> buttons = new ArrayList<EasyButton>();

    public TimeUtil.TimeData getTime() {
        return new TimeUtil.TimeData(this.days, this.hours, this.minutes, this.seconds);
    }

    private TimeInputWidget(Builder builder) {
        super(builder);
        this.timeConsumer = builder.handler;
        this.relevantUnits = this.getRelevantUnits(builder.largestUnit, builder.smallestUnit);
        this.spacing = builder.spacing;
        this.minDuration = builder.minDuration;
        this.maxDuration = builder.maxDuration;
        this.setTimeInternal(builder.startTime);
        this.validateTime();
    }

    @Override
    public void addChildren(@Nonnull ScreenArea area) {
        for (int i = 0; i < this.relevantUnits.size(); ++i) {
            TimeUtil.TimeUnit unit = this.relevantUnits.get(i);
            int xOff = (20 + this.spacing) * i;
            this.buttons.add(this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(area.pos.offset(xOff, 0))).pressAction(() -> this.addTime(unit))).sprite(MoneyValueWidget.SPRITE_UP_ARROW).build()));
            this.buttons.add(this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(area.pos.offset(xOff, 23))).pressAction(() -> this.removeTime(unit))).sprite(MoneyValueWidget.SPRITE_DOWN_ARROW).build()));
        }
    }

    public void setTime(long milliseconds) {
        this.setTimeInternal(milliseconds);
        this.validateTime();
        this.timeConsumer.accept(this.getTime());
    }

    public void setTime(TimeUtil.TimeData time) {
        this.setTimeInternal(time);
        this.validateTime();
        this.timeConsumer.accept(this.getTime());
    }

    public void setTime(long days, long hours, long minutes, long seconds) {
        this.setTimeInternal(days, hours, minutes, seconds);
        this.validateTime();
        this.timeConsumer.accept(this.getTime());
    }

    private void setTimeInternal(long milliseconds) {
        this.setTimeInternal(new TimeUtil.TimeData(milliseconds));
    }

    private void setTimeInternal(TimeUtil.TimeData time) {
        this.setTimeInternal(time.days, time.hours, time.minutes, time.seconds);
    }

    private void setTimeInternal(long days, long hours, long minutes, long seconds) {
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        if (!this.validUnit(TimeUtil.TimeUnit.DAY)) {
            this.hours += this.days * 24L;
            this.days = 0L;
        }
        if (!this.validUnit(TimeUtil.TimeUnit.HOUR)) {
            this.minutes += this.hours * 60L;
            this.hours = 0L;
        }
        if (!this.validUnit(TimeUtil.TimeUnit.MINUTE)) {
            this.seconds += this.minutes * 60L;
            this.minutes = 0L;
        }
        if (!this.validUnit(TimeUtil.TimeUnit.SECOND)) {
            this.seconds = 0L;
        }
    }

    private boolean validUnit(TimeUtil.TimeUnit unit) {
        return this.relevantUnits.contains((Object)unit);
    }

    private void addTime(TimeUtil.TimeUnit unit) {
        switch (unit) {
            case DAY: {
                ++this.days;
                break;
            }
            case HOUR: {
                ++this.hours;
                if (this.hours < 24L || !this.validUnit(TimeUtil.TimeUnit.DAY)) break;
                this.days += this.hours / 24L;
                this.hours %= 24L;
                break;
            }
            case MINUTE: {
                ++this.minutes;
                if (this.minutes < 60L || !this.validUnit(TimeUtil.TimeUnit.HOUR)) break;
                this.hours += this.minutes / 60L;
                this.minutes %= 60L;
                break;
            }
            case SECOND: {
                ++this.seconds;
                if (this.seconds < 60L || !this.validUnit(TimeUtil.TimeUnit.SECOND)) break;
                this.minutes += this.seconds / 60L;
                this.seconds %= 60L;
            }
        }
        this.validateTime();
        this.timeConsumer.accept(this.getTime());
    }

    private void removeTime(TimeUtil.TimeUnit unit) {
        this.removeTimeInternal(unit);
        this.validateTime();
        this.timeConsumer.accept(this.getTime());
    }

    private void removeTimeInternal(TimeUtil.TimeUnit unit) {
        switch (unit) {
            case DAY: {
                this.days = Math.max(0L, this.days - 1L);
                break;
            }
            case HOUR: {
                --this.hours;
                if (this.hours >= 0L) break;
                if (this.days > 0L) {
                    this.removeTimeInternal(TimeUtil.TimeUnit.DAY);
                    this.hours += 24L;
                    break;
                }
                this.hours = 0L;
                break;
            }
            case MINUTE: {
                --this.minutes;
                if (this.minutes >= 0L) break;
                if (this.hours > 0L || this.days > 0L) {
                    this.removeTimeInternal(TimeUtil.TimeUnit.HOUR);
                    this.minutes += 60L;
                    break;
                }
                this.minutes = 0L;
                break;
            }
            case SECOND: {
                --this.seconds;
                if (this.seconds >= 0L) break;
                if (this.minutes > 0L || this.hours > 0L || this.days > 0L) {
                    this.removeTimeInternal(TimeUtil.TimeUnit.MINUTE);
                    this.seconds += 60L;
                    break;
                }
                this.seconds = 0L;
            }
        }
    }

    private void validateTime() {
        long duration = this.getTime().miliseconds;
        if (duration > this.maxDuration) {
            this.setTimeInternal(this.maxDuration);
        }
        if (duration < this.minDuration) {
            this.setTimeInternal(this.minDuration);
        }
    }

    private List<TimeUtil.TimeUnit> getRelevantUnits(TimeUtil.TimeUnit largestUnit, TimeUtil.TimeUnit smallestUnit) {
        ArrayList<TimeUtil.TimeUnit> results = new ArrayList<TimeUtil.TimeUnit>();
        List<TimeUtil.TimeUnit> units = TimeUtil.TimeUnit.UNITS_LARGE_TO_SMALL;
        int startIndex = units.indexOf((Object)largestUnit);
        if (startIndex < 0) {
            throw new RuntimeException("TimeUnit '" + largestUnit + "' could not be found on the TimeUnit list!");
        }
        for (int i = startIndex; i < units.size(); ++i) {
            TimeUtil.TimeUnit unit = units.get(i);
            results.add(unit);
            if (unit == smallestUnit) break;
        }
        return results;
    }

    @Override
    protected void renderTick() {
        for (EasyButton b : this.buttons) {
            b.f_93623_ = this.f_93623_;
            b.f_93624_ = this.f_93624_;
        }
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        for (int i = 0; i < this.relevantUnits.size(); ++i) {
            TextRenderUtil.drawCenteredText(gui, this.getTime().getUnitString(this.relevantUnits.get(i), true), (20 + this.spacing) * i + 10, 12, 0xFFFFFF);
        }
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyWidget.EasyBuilder<Builder> {
        private int spacing = 10;
        private TimeUtil.TimeUnit smallestUnit = TimeUtil.TimeUnit.SECOND;
        private TimeUtil.TimeUnit largestUnit = TimeUtil.TimeUnit.DAY;
        private Consumer<TimeUtil.TimeData> handler = t -> {};
        private long minDuration = 0L;
        private long maxDuration = Long.MAX_VALUE;
        private long startTime = 0L;

        private Builder() {
            super(0, 0);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder spacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        public Builder smallestUnit(TimeUtil.TimeUnit unit) {
            this.smallestUnit = unit;
            return this;
        }

        public Builder largestUnit(TimeUtil.TimeUnit unit) {
            this.largestUnit = unit;
            return this;
        }

        public Builder unitRange(TimeUtil.TimeUnit smallestUnit, TimeUtil.TimeUnit largestUnit) {
            this.smallestUnit = smallestUnit;
            this.largestUnit = largestUnit;
            return this;
        }

        public Builder minDuration(long minDuration) {
            this.minDuration = minDuration;
            return this;
        }

        public Builder maxDuration(long maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public Builder range(long minDuration, long maxDuration) {
            this.minDuration = minDuration;
            this.maxDuration = maxDuration;
            return this;
        }

        public Builder startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder startTime(TimeUtil.TimeData startTime) {
            this.startTime = startTime.miliseconds;
            return this;
        }

        public Builder handler(Runnable handler) {
            this.handler = t -> handler.run();
            return this;
        }

        public Builder handler(Consumer<TimeUtil.TimeData> handler) {
            this.handler = handler;
            return this;
        }

        public TimeInputWidget build() {
            return new TimeInputWidget(this);
        }
    }
}

