/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.api.ownership.listing.PotentialOwner;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OwnerSelectButton
extends EasyButton
implements ITooltipWidget {
    private final Supplier<OwnerData> currentOwner;
    private final Supplier<PotentialOwner> ownerSupplier;
    private final Supplier<Boolean> parentVisible;
    public static final int HEIGHT = 20;

    public PotentialOwner getOwner() {
        return this.ownerSupplier.get();
    }

    private OwnerSelectButton(Builder builder) {
        super(builder);
        this.currentOwner = builder.selectedOwner;
        this.ownerSupplier = builder.owner;
        this.parentVisible = builder.visible;
    }

    @Override
    protected void renderTick() {
        OwnerData data;
        PotentialOwner owner = this.getOwner();
        this.setVisible(this.parentVisible.get() != false && owner != null);
        if (this.f_93624_ && (data = this.currentOwner.get()) != null) {
            this.setActive(!data.getValidOwner().matches(owner.asOwner()));
        }
    }

    @Override
    protected void renderWidget(EasyGuiGraphics gui) {
        PotentialOwner owner = this.getOwner();
        if (owner == null) {
            this.setVisible(false);
            return;
        }
        float color = this.m_142518_() ? 1.0f : 0.5f;
        gui.setColor(color, color, color);
        SpriteUtil.createButtonBrown(this.f_93618_, this.f_93619_).render(gui, 0, 0, this);
        IconData icon = owner.getIcon();
        if (icon != null) {
            icon.render(gui, 2, 2);
        }
        Component name = TextRenderUtil.fitString((Component)owner.getName(), this.f_93618_ - 22);
        int textColor = this.m_142518_() ? 0xFFFFFF : 0x3FBFBF;
        gui.drawShadowed(name, 22, 6, textColor);
        gui.resetColor();
    }

    @Override
    public List<Component> getTooltipText() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        PotentialOwner owner = this.getOwner();
        if (owner != null) {
            owner.appendTooltip(tooltip);
        }
        return tooltip;
    }

    public static Builder builder() {
        return new Builder();
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyButton.EasyButtonBuilder<Builder> {
        private Supplier<OwnerData> selectedOwner = () -> null;
        private Supplier<PotentialOwner> owner = () -> null;
        private Supplier<Boolean> visible = () -> true;

        private Builder() {
            super(100, 20);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder width(int width) {
            this.changeWidth(width);
            return this;
        }

        public Builder selected(Supplier<OwnerData> selectedOwner) {
            this.selectedOwner = selectedOwner;
            return this;
        }

        public Builder potentialOwner(Supplier<PotentialOwner> owner) {
            this.owner = owner;
            return this;
        }

        public Builder visible(Supplier<Boolean> visible) {
            this.visible = visible;
            return this;
        }

        public OwnerSelectButton build() {
            return new OwnerSelectButton(this);
        }
    }
}

