/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.notifications;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import io.github.lightman314.lightmanscurrency.util.ListUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class NotificationDisplayWidget
extends EasyWidgetWithChildren
implements IScrollable,
ITooltipWidget {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/notifications.png");
    public static final int HEIGHT_PER_ROW = 22;
    private final Supplier<Boolean> showGeneralMessage;
    private final Supplier<List<Notification>> notificationSource;
    private final int rowCount;
    private final boolean colorIfUnseen;
    List<Component> tooltip = null;
    private Consumer<Integer> deletionHandler = null;
    private Supplier<Boolean> canDelete = () -> false;
    private int scroll = 0;

    public static int CalculateHeight(int rowCount) {
        return rowCount * 22;
    }

    private List<Notification> getNotifications() {
        return this.notificationSource.get();
    }

    public void setDeletionHandler(@Nullable Consumer<Integer> deletionHandler, @Nullable Supplier<Boolean> canDelete) {
        this.deletionHandler = deletionHandler;
        this.canDelete = canDelete == null ? () -> false : canDelete;
    }

    private NotificationDisplayWidget(Builder builder) {
        super(builder);
        this.notificationSource = builder.source;
        this.showGeneralMessage = builder.showGeneral;
        this.rowCount = builder.rowCount;
        this.colorIfUnseen = builder.colorIfUnseen;
    }

    @Override
    public void addChildren(ScreenArea area) {
        for (int i = 0; i < this.rowCount; ++i) {
            int row = i;
            this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(area.pos.offset(this.f_93618_ - 21, 1 + i * 22))).pressAction(() -> this.deleteNotification(row))).icon(IconUtil.ICON_X).addon(EasyAddonHelper.visibleCheck(this.deleteButtonVisible(row)))).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_NOTIFICATION_DELETE))).build());
        }
    }

    private Supplier<Boolean> deleteButtonVisible(int row) {
        return () -> {
            if (this.canDelete.get().booleanValue()) {
                return this.getNotifications().size() > row;
            }
            return false;
        };
    }

    @Override
    public void renderWidget(EasyGuiGraphics gui) {
        this.validateScroll();
        this.tooltip = null;
        boolean showGeneral = this.showGeneralMessage.get();
        List<Notification> notifications = this.getNotifications();
        int index = this.scroll;
        boolean deletingEnabled = this.canDelete.get();
        for (int y = 0; y < this.rowCount && index < notifications.size(); ++y) {
            int thisWidth;
            int yPos = y * 22;
            Notification n = notifications.get(index++);
            gui.resetColor();
            int vPos = !n.wasSeen() && this.colorIfUnseen ? 222 : 200;
            gui.blit(GUI_TEXTURE, 0, yPos, 0, vPos, 2, 22);
            for (int xPos = 2; xPos < this.f_93618_ - 2; xPos += thisWidth) {
                thisWidth = Math.min(166, this.f_93618_ - 2 - xPos);
                gui.blit(GUI_TEXTURE, xPos, yPos, 2, vPos, thisWidth, 22);
            }
            gui.blit(GUI_TEXTURE, this.f_93618_ - 2, yPos, 168, 200, 2, 22);
            int textXPos = 2;
            int textWidth = this.f_93618_ - 4;
            if (deletingEnabled) {
                textWidth -= 20;
            }
            int textColor = 0;
            if (n.getCount() > 1) {
                String countText = String.valueOf(n.getCount());
                int quantityWidth = gui.font.m_92895_(countText);
                gui.blit(GUI_TEXTURE, 1 + quantityWidth, yPos, 170, vPos, 3, 22);
                Objects.requireNonNull(gui.font);
                gui.drawString(countText, textXPos, yPos + 11 - 9 / 2, textColor);
                textXPos += quantityWidth + 2;
                textWidth -= quantityWidth + 2;
            }
            List<Component> message = showGeneral ? n.getGeneralMessage() : n.getMessageLines();
            ArrayList lines = new ArrayList();
            for (Component line : message) {
                lines.addAll(gui.font.m_92923_((FormattedText)line, textWidth));
            }
            if (lines.size() == 1) {
                FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines.get(0);
                Objects.requireNonNull(gui.font);
                gui.drawString(formattedCharSequence, textXPos, yPos + 11 - 9 / 2, textColor);
            } else {
                for (int l = 0; l < lines.size() && l < 2; ++l) {
                    gui.drawString((FormattedCharSequence)lines.get(l), textXPos, yPos + 2 + l * 10, textColor);
                }
            }
            int maxX = this.m_252754_() + this.f_93618_;
            if (this.canDelete.get().booleanValue()) {
                maxX -= 22;
            }
            if (this.tooltip != null || gui.mousePos.x < this.m_252754_() || gui.mousePos.x >= maxX || gui.mousePos.y < this.m_252907_() + yPos || gui.mousePos.y >= this.m_252907_() + yPos + 22) continue;
            this.tooltip = new ArrayList<Component>();
            if (n.hasTimeStamp()) {
                this.tooltip.add(n.getTimeStampMessage());
            }
            if (lines.size() <= 2) continue;
            this.tooltip.addAll(TooltipHelper.splitTooltips(ListUtil.convertList(message), new ChatFormatting[0]));
        }
    }

    @Override
    public List<Component> getTooltipText() {
        if (this.tooltip != null && !this.tooltip.isEmpty()) {
            return this.tooltip;
        }
        return null;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    @Override
    public int getMaxScroll() {
        return Math.max(0, this.getNotifications().size() - this.rowCount);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        this.handleScrollWheel(scroll);
        return true;
    }

    private void deleteNotification(int buttonRow) {
        int notificationRow = buttonRow + this.scroll;
        if (this.deletionHandler != null) {
            this.deletionHandler.accept(notificationRow);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyWidget.EasyBuilder<Builder> {
        private int rowCount = 1;
        private Supplier<List<Notification>> source = ImmutableList::of;
        private Supplier<Boolean> showGeneral = () -> false;
        private boolean colorIfUnseen = false;

        private Builder() {
            super(100, NotificationDisplayWidget.CalculateHeight(1));
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder width(int width) {
            this.changeWidth(width);
            return this;
        }

        public Builder rowCount(int rowCount) {
            this.rowCount = rowCount;
            this.changeHeight(NotificationDisplayWidget.CalculateHeight(this.rowCount));
            return this;
        }

        public Builder notificationSource(Supplier<List<Notification>> source) {
            this.source = source;
            return this;
        }

        public Builder showGeneral(Supplier<Boolean> showGeneral) {
            this.showGeneral = showGeneral;
            return this;
        }

        public Builder colorIfUnseen() {
            this.colorIfUnseen = true;
            return this;
        }

        public NotificationDisplayWidget build() {
            return new NotificationDisplayWidget(this);
        }
    }
}

