/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.builtin;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperty;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class InputDisplayOffset {
    public static final VariantProperty<InputDisplayOffset> PROPERTY = new InputDisplayOffsetProperty();
    private final Map<Direction, ScreenPosition> offsetMap;

    public InputDisplayOffset(Map<Direction, ScreenPosition> offsetMap) {
        this.offsetMap = ImmutableMap.copyOf(offsetMap);
    }

    public ScreenPosition getOffset(Direction side) {
        return this.offsetMap.getOrDefault(side, ScreenPosition.ZERO);
    }

    private static class InputDisplayOffsetProperty
    extends VariantProperty<InputDisplayOffset> {
        private InputDisplayOffsetProperty() {
        }

        @Override
        public InputDisplayOffset parse(JsonElement element) throws JsonSyntaxException, ResourceLocationException {
            String elementName = this.getID().toString();
            HashMap<Direction, ScreenPosition> offsetMap = new HashMap<Direction, ScreenPosition>();
            JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)elementName);
            for (Direction side : Direction.values()) {
                if (!json.has(side.toString())) continue;
                JsonObject field = GsonHelper.m_13930_((JsonObject)json, (String)side.toString());
                int x = GsonHelper.m_13824_((JsonObject)field, (String)"x", (int)0);
                int y = GsonHelper.m_13824_((JsonObject)field, (String)"y", (int)0);
                if (x == 0 && y == 0) continue;
                offsetMap.put(side, ScreenPosition.of(x, y));
            }
            return new InputDisplayOffset(offsetMap);
        }

        @Override
        public JsonElement write(Object value) {
            if (value instanceof InputDisplayOffset) {
                InputDisplayOffset data = (InputDisplayOffset)value;
                JsonObject json = new JsonObject();
                data.offsetMap.forEach((side, offset) -> {
                    if (offset.x != 0 || offset.y != 0) {
                        JsonObject field = new JsonObject();
                        if (offset.x != 0) {
                            field.addProperty("x", (Number)offset.x);
                        }
                        if (offset.y != 0) {
                            field.addProperty("y", (Number)offset.y);
                        }
                        json.add(side.toString(), (JsonElement)field);
                    }
                });
                return json;
            }
            throw new IllegalArgumentException("Value must be an InputDisplayOffset element!");
        }
    }
}

