/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.common.crafting.RecipeTypes;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CoinMintRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final int duration;
    private final Ingredient ingredient;
    public final int ingredientCount;
    private final ItemStack result;

    public CoinMintRecipe(ResourceLocation id, int duration, Ingredient ingredient, int ingredientCount, ItemStack result) {
        this.id = id;
        this.duration = duration;
        this.ingredient = ingredient;
        this.ingredientCount = Math.max(ingredientCount, 1);
        this.result = result;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public boolean isValid() {
        return !this.ingredient.m_43947_() && this.result.m_41720_() != Items.f_41852_;
    }

    public boolean m_5818_(@Nonnull Container inventory, @Nonnull Level level) {
        if (!this.isValid()) {
            return false;
        }
        ItemStack firstStack = inventory.m_8020_(0);
        return this.ingredient.test(firstStack);
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull Container inventory, @Nonnull RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess);
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack getOutputItem() {
        return this.result.m_41777_();
    }

    @Nonnull
    public ItemStack m_8043_(@Nonnull RegistryAccess registryAccess) {
        if (this.isValid()) {
            return this.result.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public int getInternalDuration() {
        return this.duration;
    }

    public int getDuration() {
        return this.duration > 0 ? this.duration : (Integer)LCConfig.SERVER.coinMintDefaultDuration.get();
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.COIN_MINT.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypes.COIN_MINT.get();
    }

    @Nonnull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.COIN_MINT.get());
    }

    public static class Serializer
    implements RecipeSerializer<CoinMintRecipe> {
        @Nonnull
        public CoinMintRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            int ingredientCount = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            if (result.m_41619_()) {
                throw new JsonSyntaxException("Result is empty.");
            }
            int duration = GsonHelper.m_13824_((JsonObject)json, (String)"duration", (int)0);
            return new CoinMintRecipe(recipeId, duration, ingredient, ingredientCount, result);
        }

        public CoinMintRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int ingredientCount = buffer.readInt();
            ItemStack result = buffer.m_130267_();
            int duration = buffer.readInt();
            return new CoinMintRecipe(recipeId, duration, ingredient, ingredientCount, result);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, CoinMintRecipe recipe) {
            recipe.getIngredient().m_43923_(buffer);
            buffer.writeInt(recipe.ingredientCount);
            buffer.writeItemStack(recipe.getOutputItem(), false);
            buffer.writeInt(recipe.getInternalDuration());
        }
    }
}

