/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.enchantments.data;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemOverride {
    public final MoneyValue baseCost;
    private final List<ResourceLocation> items;
    private final List<TagKey<Item>> tags;

    public ItemOverride(MoneyValue baseCost, List<String> inputs) {
        this.baseCost = baseCost;
        ArrayList<ResourceLocation> itemTemp = new ArrayList<ResourceLocation>();
        ArrayList<TagKey> tagTemp = new ArrayList<TagKey>();
        for (String entry : inputs) {
            if (entry.startsWith("#")) {
                tagTemp.add(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)VersionUtil.parseResource(entry.substring(1))));
                continue;
            }
            itemTemp.add(VersionUtil.parseResource(entry));
        }
        this.items = ImmutableList.copyOf(itemTemp);
        this.tags = ImmutableList.copyOf(tagTemp);
    }

    public List<String> writeList() {
        ArrayList<String> list = new ArrayList<String>();
        for (TagKey<Item> tag : this.tags) {
            list.add("#" + tag.f_203868_());
        }
        for (ResourceLocation item : this.items) {
            list.add(item.toString());
        }
        return list;
    }

    public boolean matches(@Nonnull ItemStack item) {
        return this.items.contains(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_())) || this.tags.stream().anyMatch(t -> InventoryUtil.ItemHasTag(item, (TagKey<Item>)t));
    }
}

