/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items.cards;

import io.github.lightman314.lightmanscurrency.api.capability.money.MoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class PrepaidCardMoneyHandler
extends MoneyHandler {
    private final ItemStack card;

    public PrepaidCardMoneyHandler(@Nonnull ItemStack card) {
        this.card = card;
    }

    @Nonnull
    private MoneyValue getCardMoney() {
        CompoundTag tag = this.card.m_41784_();
        return tag.m_128441_("StoredMoney") ? MoneyValue.load(tag.m_128469_("StoredMoney")) : MoneyValue.empty();
    }

    private void setCardMoney(@Nonnull MoneyValue value) {
        CompoundTag tag = this.card.m_41784_();
        tag.m_128365_("StoredMoney", (Tag)value.save());
        if (value.isEmpty()) {
            this.card.m_41764_(0);
        }
    }

    @Override
    @Nonnull
    public MoneyValue insertMoney(@Nonnull MoneyValue insertAmount, boolean simulation) {
        return insertAmount;
    }

    @Override
    @Nonnull
    public MoneyValue extractMoney(@Nonnull MoneyValue extractAmount, boolean simulation) {
        MoneyValue value = this.getCardMoney();
        if (value.sameType(extractAmount)) {
            MoneyValue amountToTake;
            MoneyValue moneyValue = amountToTake = value.containsValue(extractAmount) ? extractAmount : value;
            if (!simulation) {
                this.setCardMoney(value.subtractValue(amountToTake));
            }
            return extractAmount.subtractValue(amountToTake);
        }
        return extractAmount;
    }

    @Override
    public boolean isMoneyTypeValid(@Nonnull MoneyValue value) {
        return this.getCardMoney().sameType(value);
    }

    @Override
    protected void collectStoredMoney(@Nonnull MoneyView.Builder builder) {
        builder.add(this.getCardMoney());
    }
}

