/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.slot_machine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.stats.StatKeys;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TradeResult;
import io.github.lightman314.lightmanscurrency.api.traders.TraderType;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.blockentity.handler.TraderItemHandler;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import io.github.lightman314.lightmanscurrency.common.menus.slot_machine.ResultHolder;
import io.github.lightman314.lightmanscurrency.common.menus.slot_machine.SlotMachineMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.slot_machine.SlotMachineEntryTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.slot_machine.SlotMachinePriceTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.slot_machine.SlotMachineStorageTab;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.OutOfStockNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.SlotMachineTradeNotification;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.trade_data.SlotMachineTrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.Upgrades;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.common.util.TagUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SlotMachineTraderData
extends InputTraderData
implements TraderItemStorage.ITraderItemFilter,
TraderItemHandler.IItemStorageProvider {
    public static final TraderType<SlotMachineTraderData> TYPE = new TraderType(VersionUtil.lcResource("slot_machine_trader"), SlotMachineTraderData::new);
    TraderItemHandler<SlotMachineTraderData> itemHandler = new TraderItemHandler<SlotMachineTraderData>(this);
    private MoneyValue price = MoneyValue.empty();
    private final NonNullList<IconData> lastIcons = SlotMachineEntry.createDefaultIcons();
    private final List<SlotMachineEntry> entries = Lists.newArrayList((Object[])new SlotMachineEntry[]{SlotMachineEntry.create()});
    private boolean entriesChanged = false;
    private final TraderItemStorage storage = new TraderItemStorage(this);
    private final ImmutableList<SlotMachineTrade> trade = ImmutableList.of((Object)new SlotMachineTrade(this));

    public IItemHandler getItemHandler(Direction relativeSide) {
        return this.itemHandler.getHandler(relativeSide);
    }

    public final MoneyValue getPrice() {
        return this.price;
    }

    public void setPrice(MoneyValue newValue) {
        this.price = newValue;
        this.markPriceDirty();
    }

    public final boolean isPriceValid() {
        return this.price.isFree() || !this.price.isEmpty();
    }

    public List<IconData> getLastIcons() {
        return ImmutableList.copyOf(this.lastIcons);
    }

    public final List<SlotMachineEntry> getAllEntries() {
        return new ArrayList<SlotMachineEntry>(this.entries);
    }

    public final List<SlotMachineEntry> getValidEntries() {
        return this.entries.stream().filter(SlotMachineEntry::isValid).toList();
    }

    public boolean areEntriesChanged() {
        return this.entriesChanged;
    }

    public void clearEntriesChangedCache() {
        this.entriesChanged = false;
    }

    public void addEntry() {
        if (this.entries.size() >= 100) {
            return;
        }
        this.entries.add(SlotMachineEntry.create());
        this.markEntriesDirty();
    }

    public void removeEntry(int entryIndex) {
        if (entryIndex < 0 || entryIndex >= this.entries.size()) {
            return;
        }
        this.entries.remove(entryIndex);
        this.markEntriesDirty();
    }

    public final double getTotalOdds() {
        double odds = 0.0;
        for (SlotMachineEntry entry : this.getValidEntries()) {
            odds += entry.getOdds();
        }
        return odds;
    }

    public final double getFailOdds() {
        return Math.max(0.0, 100.0 - this.getTotalOdds());
    }

    public final String getFailOddsText() {
        return SlotMachineEntry.ODDS_FORMATTER.format(this.getFailOdds());
    }

    public final boolean hasValidOdds() {
        double totalOdds = this.getTotalOdds();
        return totalOdds > 0.0 && totalOdds <= 100.0;
    }

    @Nullable
    public final SlotMachineEntry getRandomizedEntry(TradeContext context) {
        Level level;
        if (context.hasPlayer()) {
            level = context.getPlayer().m_9236_();
        } else {
            try {
                level = LightmansCurrency.getProxy().safeGetDummyLevel();
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Could not get a valid level from the trade's context or the proxy. Will have to use Java randomizer");
                return this.getRandomizedEntry(new Random().nextDouble());
            }
        }
        return this.getRandomizedEntry(level.f_46441_.m_188500_());
    }

    @Nullable
    private SlotMachineEntry getRandomizedEntry(double rand) {
        rand *= 100.0;
        for (SlotMachineEntry entry : this.getValidEntries()) {
            if (!((rand -= entry.getOdds()) < 0.0)) continue;
            return entry;
        }
        return null;
    }

    public final List<Component> getSlotMachineInfo() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        if (!this.hasValidTrade()) {
            tooltips.add((Component)LCText.TOOLTIP_SLOT_MACHINE_UNDEFINED.get(new Object[0]).m_130940_(ChatFormatting.RED));
            return tooltips;
        }
        if (!this.hasStock()) {
            tooltips.add((Component)LCText.TOOLTIP_OUT_OF_STOCK.get(new Object[0]).m_130940_(ChatFormatting.RED));
        }
        return tooltips;
    }

    @Override
    public final TraderItemStorage getStorage() {
        return this.storage;
    }

    private SlotMachineTraderData() {
        super(TYPE);
    }

    public SlotMachineTraderData(Level level, BlockPos pos) {
        super(TYPE, level, pos);
    }

    @Override
    public IconData inputSettingsTabIcon() {
        return ItemIcon.ofItem((ItemLike)Items.f_42155_);
    }

    @Override
    public MutableComponent inputSettingsTabTooltip() {
        return LCText.TOOLTIP_TRADER_SETTINGS_INPUT_ITEM.get(new Object[0]);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_TRADER_ALT;
    }

    @Override
    protected boolean allowAdditionalUpgradeType(UpgradeType type) {
        return type == Upgrades.ITEM_CAPACITY;
    }

    @Override
    public int getTradeCount() {
        return 1;
    }

    @Override
    public int getTradeStock(int tradeIndex) {
        if (!this.hasValidTrade()) {
            return 0;
        }
        if (this.isCreative()) {
            return 1;
        }
        int minStock = Integer.MAX_VALUE;
        for (SlotMachineEntry entry : this.entries) {
            int stock = entry.getStock(this);
            if (stock >= minStock) continue;
            minStock = stock;
        }
        return minStock;
    }

    public boolean hasStock() {
        return this.getTradeStock(0) > 0;
    }

    @Override
    public boolean hasValidTrade() {
        return this.entries.stream().anyMatch(SlotMachineEntry::isValid) && this.isPriceValid() && this.hasValidOdds();
    }

    @Override
    protected void saveTrades(CompoundTag compound) {
    }

    @Override
    protected MenuProvider getTraderMenuProvider(MenuValidator validator) {
        return new SlotMachineMenuProvider(this.getID(), validator);
    }

    @Override
    public final void markStorageDirty() {
        this.markDirty(this::saveStorage);
    }

    public final void markLastIconsDirty() {
        this.markDirty(this::saveLastIcons);
    }

    public final void markEntriesDirty() {
        this.markDirty(this::saveEntries);
    }

    public final void markPriceDirty() {
        this.markDirty(this::savePrice);
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        this.saveStorage(compound);
        this.saveLastIcons(compound);
        this.saveEntries(compound);
        this.savePrice(compound);
    }

    protected final void saveStorage(CompoundTag compound) {
        this.storage.save(compound, "Storage");
    }

    protected final void saveLastIcons(CompoundTag compound) {
        compound.m_128365_("LastIcons", (Tag)TagUtil.writeIconList(this.lastIcons));
    }

    protected final void saveEntries(CompoundTag compound) {
        ListTag list = new ListTag();
        for (SlotMachineEntry entry : this.entries) {
            list.add((Object)entry.save());
        }
        compound.m_128365_("Entries", (Tag)list);
    }

    protected final void savePrice(CompoundTag compound) {
        compound.m_128365_("Price", (Tag)this.price.save());
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        super.loadAdditional(compound);
        if (compound.m_128441_("Storage")) {
            this.storage.load(compound, "Storage");
        }
        this.loadLastIcons(compound);
        if (compound.m_128441_("Entries")) {
            this.entries.clear();
            ArrayList<Integer> deprecatedWeights = new ArrayList<Integer>();
            ListTag list = compound.m_128437_("Entries", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag e = list.m_128728_(i);
                this.entries.add(SlotMachineEntry.load(e));
                if (!e.m_128441_("Weight")) continue;
                deprecatedWeights.add(e.m_128451_("Weight"));
            }
            if (!deprecatedWeights.isEmpty() && deprecatedWeights.size() == this.entries.size()) {
                int totalWeight = 0;
                for (Integer w : deprecatedWeights) {
                    totalWeight += w.intValue();
                }
                if (totalWeight > 0) {
                    for (int i = 0; i < deprecatedWeights.size(); ++i) {
                        this.entries.get(i).setOdds((double)((Integer)deprecatedWeights.get(i)).intValue() / (double)totalWeight * 100.0);
                    }
                }
            }
            this.entriesChanged = true;
        }
        if (compound.m_128441_("Price")) {
            this.price = MoneyValue.safeLoad(compound, "Price");
        }
    }

    private void loadLastIcons(CompoundTag compound) {
        if (compound.m_128441_("LastReward")) {
            int i;
            List<ItemStack> lastReward = new ArrayList<ItemStack>();
            ListTag itemList = compound.m_128437_("LastReward", 10);
            for (i = 0; i < itemList.size(); ++i) {
                ItemStack stack = InventoryUtil.loadItemNoLimits(itemList.m_128728_(i));
                if (stack.m_41619_()) continue;
                lastReward.add(stack);
            }
            lastReward = SlotMachineEntry.splitDisplayItems(lastReward);
            for (i = 0; i < lastReward.size() && i < this.lastIcons.size(); ++i) {
                this.lastIcons.set(i, (Object)ItemIcon.ofItem(lastReward.get(i)));
            }
        }
        if (compound.m_128441_("LastIcons")) {
            TagUtil.readIconList(this.lastIcons, compound.m_128437_("LastIcons", 10), SlotMachineEntry.DEFAULT_ICON);
        }
    }

    @Override
    protected void saveAdditionalToJson(JsonObject json) {
        json.add("Price", (JsonElement)this.price.toJson());
        JsonArray entryList = new JsonArray();
        for (SlotMachineEntry entry : this.entries) {
            if (!entry.isValid()) continue;
            entryList.add((JsonElement)entry.toJson());
        }
        json.add("Entries", (JsonElement)entryList);
    }

    @Override
    protected void loadAdditionalFromJson(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        if (!json.has("Price")) {
            throw new JsonSyntaxException("Expected a 'Price' entry!");
        }
        this.price = MoneyValue.loadFromJson(json.get("Price"));
        this.entries.clear();
        JsonArray entryList = GsonHelper.m_13933_((JsonObject)json, (String)"Entries");
        for (int i = 0; i < entryList.size(); ++i) {
            try {
                this.entries.add(SlotMachineEntry.parse(GsonHelper.m_13918_((JsonElement)entryList.get(i), (String)("Entries[" + i + "]"))));
                continue;
            }
            catch (JsonSyntaxException | ResourceLocationException t) {
                LightmansCurrency.LogError("Error parsing Slot Machine Trader Entry #" + (i + 1), t);
            }
        }
        if (this.entries.isEmpty()) {
            throw new JsonSyntaxException("Slot Machine Trader had no valid Entries!");
        }
    }

    @Override
    protected void saveAdditionalPersistentData(CompoundTag compound) {
        this.saveLastIcons(compound);
    }

    @Override
    protected void loadAdditionalPersistentData(CompoundTag compound) {
        this.loadLastIcons(compound);
    }

    @Override
    protected void getAdditionalContents(List<ItemStack> results) {
        results.addAll(this.storage.getSplitContents());
    }

    public List<SlotMachineTrade> getTradeData() {
        return this.trade;
    }

    @Override
    @Nullable
    public SlotMachineTrade getTrade(int tradeIndex) {
        return (SlotMachineTrade)this.trade.get(0);
    }

    @Override
    public void addTrade(Player requestor) {
    }

    @Override
    public void removeTrade(Player requestor) {
    }

    @Override
    public TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        if (!this.hasValidTrade()) {
            return TradeResult.FAIL_INVALID_TRADE;
        }
        SlotMachineTrade trade = (SlotMachineTrade)this.trade.get(0);
        if (trade == null) {
            LightmansCurrency.LogError("Slot Machine somehow doesn't have a valid trade!");
            return TradeResult.FAIL_INVALID_TRADE;
        }
        if (!context.hasPlayerReference()) {
            return TradeResult.FAIL_NULL;
        }
        if (!this.hasStock()) {
            return TradeResult.FAIL_OUT_OF_STOCK;
        }
        if (this.runPreTradeEvent(trade, context).isCanceled()) {
            return TradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        MoneyValue price = this.runTradeCostEvent(trade, context).getCostResult();
        SlotMachineEntry loot = this.getRandomizedEntry(context);
        if (loot != null && !loot.CanGiveToCustomer(context)) {
            return TradeResult.FAIL_NO_OUTPUT_SPACE;
        }
        if (context.getPayment(price)) {
            Object object;
            if (loot != null && !loot.GiveToCustomer(this, context)) {
                context.givePayment(price);
                return TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            Object newIcons = loot == null ? SlotMachineEntry.createDefaultIcons() : loot.getIconsToDisplay();
            this.lastIcons.clear();
            for (int i = 0; i < newIcons.size() && i < this.lastIcons.size(); ++i) {
                this.lastIcons.set(i, (Object)((IconData)newIcons.get(i)));
            }
            if (context.hasCustomData(ResultHolder.CONTEXT_KEY) && (object = context.getCustomData(ResultHolder.CONTEXT_KEY)) instanceof ResultHolder) {
                ResultHolder holder = (ResultHolder)object;
                holder.setIcons((List<IconData>)ImmutableList.copyOf(this.lastIcons));
            }
            this.markLastIconsDirty();
            MoneyValue taxesPaid = MoneyValue.empty();
            if (!this.isCreative()) {
                taxesPaid = this.addStoredMoney(price, true);
                if (!this.hasStock()) {
                    this.pushNotification(OutOfStockNotification.create(this.getNotificationCategory(), -1));
                }
            }
            this.incrementStat(StatKeys.Traders.MONEY_EARNED, price);
            if (!taxesPaid.isEmpty()) {
                this.incrementStat(StatKeys.Taxables.TAXES_PAID, taxesPaid);
            }
            if (loot != null && loot.isMoney()) {
                this.incrementStat(StatKeys.Traders.MONEY_PAID, loot.getMoneyValue());
            }
            this.pushNotification(SlotMachineTradeNotification.create(loot, price, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
            ArrayList<MoneyValue> product = new ArrayList<MoneyValue>();
            if (loot != null) {
                if (loot.isMoney()) {
                    product.add(loot.getMoneyValue());
                } else {
                    product.addAll(InventoryUtil.copyList(loot.items));
                }
            }
            this.runPostTradeEvent((TradeData)trade, context, price, taxesPaid, product);
            return TradeResult.SUCCESS;
        }
        return TradeResult.FAIL_CANNOT_AFFORD;
    }

    @Override
    public boolean canMakePersistent() {
        return true;
    }

    @Override
    public void initStorageTabs(ITraderStorageMenu menu) {
        menu.setTab(0, new SlotMachineEntryTab(menu));
        menu.setTab(1, new SlotMachinePriceTab(menu));
        menu.setTab(2, new SlotMachineStorageTab(menu));
    }

    @Override
    public boolean isItemRelevant(ItemStack item) {
        for (SlotMachineEntry entry : this.entries) {
            if (!entry.isItemRelevant(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowExtraction(ItemStack stack) {
        return !this.isItemRelevant(stack);
    }

    @Override
    public int getStorageStackLimit() {
        int limit = 576;
        for (int i = 0; i < this.getUpgrades().m_6643_(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgrades().m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)item) || upgradeItem.getUpgradeType() != Upgrades.ITEM_CAPACITY) continue;
            limit += UpgradeItem.getUpgradeData(stack).getIntValue(CapacityUpgrade.CAPACITY);
        }
        return limit;
    }

    private record SlotMachineMenuProvider(long traderID, MenuValidator validator) implements EasyMenuProvider
    {
        public AbstractContainerMenu m_7208_(int windowID, Inventory inventory, Player player) {
            return new SlotMachineMenu(windowID, inventory, this.traderID, this.validator);
        }
    }
}

