/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader;

import com.google.common.base.Predicates;
import com.mojang.datafixers.util.Either;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.util.ArgumentHelpers;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.stats.StatType;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.attachments.builtin.ExternalAuthorizationAttachment;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.AddRemoveAllyNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeAllyPermissionNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeNameNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeSettingNotification;
import io.github.lightman314.lightmanscurrency.integration.computercraft.AccessTrackingPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheral;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCPeripheralMethod;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader.TradeWrapper;
import io.github.lightman314.lightmanscurrency.util.DebugUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class TraderPeripheral<BE extends TraderBlockEntity<T>, T extends TraderData>
extends AccessTrackingPeripheral {
    public static final String BASE_TYPE = "lc_trader";
    protected final Either<BE, Long> source;
    private final Consumer<TradeEvent.PreTradeEvent> preTradeEventListener = this::preTradeEvent;
    private final Consumer<TradeEvent.PostTradeEvent> postTradeEventListener = this::postTradeEvent;

    public TraderPeripheral(BE be) {
        this.source = Either.left(be);
    }

    public TraderPeripheral(T trader) {
        this.source = Either.right((Object)((TraderData)trader).getID());
    }

    public static LCPeripheral createSimple(TraderBlockEntity<TraderData> be) {
        return new Simple(be);
    }

    public static LCPeripheral createSimple(TraderData trader) {
        return new Simple(trader);
    }

    protected int getPermissionLevel(IComputerAccess computer, String permission) {
        String id = this.getComputerID(computer);
        if (id == null) {
            return 0;
        }
        ExternalAuthorizationAttachment trader = this.safeGetTrader();
        if (trader == null || !((TraderData)((Object)trader)).hasAttachment(ExternalAuthorizationAttachment.TYPE)) {
            return 0;
        }
        if (((TraderData)((Object)trader)).getBlockedPermissions().contains(permission)) {
            return 0;
        }
        ExternalAuthorizationAttachment.AccessLevel access = ((TraderData)((Object)trader)).getAttachment(ExternalAuthorizationAttachment.TYPE).getAccessLevel(id);
        return switch (access) {
            default -> throw new IncompatibleClassChangeError();
            case ExternalAuthorizationAttachment.AccessLevel.NONE -> 0;
            case ExternalAuthorizationAttachment.AccessLevel.ALLY -> ((TraderData)((Object)trader)).getAllyPermissionMap().getOrDefault(permission, 0);
            case ExternalAuthorizationAttachment.AccessLevel.ADMIN -> Integer.MAX_VALUE;
        };
    }

    protected boolean hasPermissions(IComputerAccess computer, String permission) {
        return this.getPermissionLevel(computer, permission) > 0;
    }

    @Nullable
    protected final BE getBlockEntity() {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        this.source.ifLeft(result::set);
        return (BE)((TraderBlockEntity)result.get());
    }

    @Nullable
    public T safeGetTrader() {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        this.source.ifLeft(be -> {
            if (be.m_58901_()) {
                return;
            }
            result.set(be.getTraderData());
        });
        this.source.ifRight(id -> {
            try {
                result.set(TraderAPI.getApi().GetTrader(false, (long)id));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return (T)((TraderData)result.get());
    }

    protected T getTrader() throws LuaException {
        if (!this.stillValid()) {
            throw new LuaException("An unexpected error occurred trying to get the traders data!");
        }
        T trader = this.safeGetTrader();
        if (trader == null) {
            throw new LuaException("An unexpected error occurred trying to get the traders data!");
        }
        return trader;
    }

    @Nullable
    protected abstract LCPeripheral wrapTrade(TradeData var1) throws LuaException;

    public Set<String> getAdditionalTypes() {
        return Set.of(BASE_TYPE);
    }

    @Override
    public boolean equals(@Nullable IPeripheral peripheral) {
        if (peripheral instanceof TraderPeripheral) {
            TraderPeripheral other = (TraderPeripheral)peripheral;
            return other.source.equals(this.source) && super.equals(peripheral);
        }
        return false;
    }

    @Override
    protected void onAttachment(IComputerAccess computer) {
        ExternalAuthorizationAttachment trader = this.safeGetTrader();
        if (trader != null && ((TraderData)((Object)trader)).hasAttachment(ExternalAuthorizationAttachment.TYPE)) {
            ((TraderData)((Object)trader)).getAttachment(ExternalAuthorizationAttachment.TYPE).flagAttemptedAccess(this.getComputerID(computer));
        }
    }

    @Override
    protected void onFirstAttachment() {
        super.onFirstAttachment();
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, true, this.preTradeEventListener);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this.postTradeEventListener);
    }

    @Override
    protected void onLastDetachment() {
        super.onLastDetachment();
        MinecraftForge.EVENT_BUS.unregister(this.preTradeEventListener);
        MinecraftForge.EVENT_BUS.unregister(this.postTradeEventListener);
    }

    public boolean isValid() {
        try {
            this.getTrader();
            return true;
        }
        catch (LuaException e) {
            return false;
        }
    }

    public long getID() throws LuaException {
        return ((TraderData)this.getTrader()).getID();
    }

    public boolean isVisibleOnNetwork() throws LuaException {
        return ((TraderData)this.getTrader()).showOnTerminal();
    }

    public boolean isCreative() throws LuaException {
        return ((TraderData)this.getTrader()).isCreative();
    }

    public boolean isPersistent() throws LuaException {
        return ((TraderData)this.getTrader()).isPersistent();
    }

    public LCLuaTable getOwner() throws LuaException {
        T trader = this.getTrader();
        Owner owner = ((TraderData)trader).getOwner().getValidOwner();
        return LCLuaTable.fromTag(owner.save());
    }

    public String getOwnerName() throws LuaException {
        return ((TraderData)this.getTrader()).getOwner().getName().getString();
    }

    public LCLuaTable getStats() throws LuaException {
        LCLuaTable table = new LCLuaTable();
        T trader = this.getTrader();
        for (String statKey : ((TraderData)trader).statTracker.getKeys()) {
            StatType.Instance<?, ?> entry = ((TraderData)trader).statTracker.getStat(statKey);
            if (entry == null) continue;
            Object display = entry.getDisplay();
            Object result = display.toString();
            if (display instanceof Component) {
                Component text = (Component)display;
                result = text.getString();
            }
            if (display instanceof Number || display instanceof Boolean) {
                result = display;
            }
            table.put(statKey, result);
        }
        return table;
    }

    public String[] getAllies() throws LuaException {
        return (String[])((TraderData)this.getTrader()).getAllies().stream().map(p -> p.getName(false)).toArray(String[]::new);
    }

    public boolean addAlly(IComputerAccess computer, IArguments args) throws LuaException {
        if (this.hasPermissions(computer, "addRemoveAllies")) {
            T trader = this.getTrader();
            PlayerReference player = PlayerReference.of(false, args.getString(0));
            if (player == null) {
                return false;
            }
            List<PlayerReference> allies = ((TraderData)trader).getAllies();
            if (PlayerReference.addToList(allies, player)) {
                ((TraderData)trader).overwriteAllies(allies);
                ((TraderData)trader).pushLocalNotification(new AddRemoveAllyNotification(this.getFakePlayer(computer), true, player));
                return true;
            }
        }
        return false;
    }

    public boolean removeAlly(IComputerAccess computer, IArguments args) throws LuaException {
        if (this.hasPermissions(computer, "addRemoveAllies")) {
            T trader = this.getTrader();
            PlayerReference player = PlayerReference.of(false, args.getString(0));
            if (player == null) {
                return false;
            }
            List<PlayerReference> allies = ((TraderData)trader).getAllies();
            if (PlayerReference.removeFromList(allies, player)) {
                ((TraderData)trader).overwriteAllies(allies);
                ((TraderData)trader).pushLocalNotification(new AddRemoveAllyNotification(this.getFakePlayer(computer), false, player));
            }
        }
        return false;
    }

    public LCLuaTable getAllyPermissions() throws LuaException {
        Object trader = this.getTrader();
        LCLuaTable table = new LCLuaTable();
        if (((TraderData)trader).isPersistent()) {
            return table;
        }
        ((TraderData)trader).getAllyPermissionMap().forEach((key, level) -> {
            if (!trader.getBlockedPermissions().contains(key)) {
                table.put(key, level);
            }
        });
        return table;
    }

    public int getAllyPermissionLevel(IArguments args) throws LuaException {
        String permission = args.getString(0);
        T trader = this.getTrader();
        if (((TraderData)trader).isPersistent() || ((TraderData)trader).getBlockedPermissions().contains(permission)) {
            return 0;
        }
        return ((TraderData)trader).getAllyPermissionMap().getOrDefault(permission, 0);
    }

    public boolean setAllyPermissionLevel(IComputerAccess computer, IArguments args) throws LuaException {
        T trader;
        Map<String, Integer> permissions;
        int oldLevel;
        String permission = args.getString(0);
        int level = args.getInt(1);
        ArgumentHelpers.assertBetween((int)level, (int)0, (int)Integer.MAX_VALUE, (String)"Permission Level is not in range (%s)");
        if (this.hasPermissions(computer, "editPermissions") && (oldLevel = (permissions = ((TraderData)(trader = this.getTrader())).getAllyPermissionMap()).getOrDefault(permission, 0).intValue()) != level) {
            permissions.put(permission, level);
            ((TraderData)trader).overwriteAllyPermissions(permissions);
            ((TraderData)trader).pushLocalNotification(new ChangeAllyPermissionNotification(this.getFakePlayer(computer), permission, level, oldLevel));
            return true;
        }
        return false;
    }

    public int getPlayerPermissionLevel(IArguments args) throws LuaException {
        T trader = this.getTrader();
        PlayerReference player = PlayerReference.of(false, args.getString(0));
        if (player == null) {
            return 0;
        }
        return ((TraderData)trader).getPermissionLevel(player, args.getString(1));
    }

    public int getMyPermissionLevel(IComputerAccess computer, IArguments args) throws LuaException {
        return this.getPermissionLevel(computer, args.getString(0));
    }

    public LCLuaTable[] getLogs(IArguments args) throws LuaException {
        Object filter = Predicates.alwaysTrue();
        int limit = 0;
        Tuple argsLoaded = new Tuple((Object)false, (Object)false);
        if (args.count() > 0) {
            if (args.count() > 2) {
                throw new LuaException("Too many arguments, expected a max of 2");
            }
            for (int i = 0; i < 2 && i < args.count(); ++i) {
                Object arg = args.get(i);
                if (arg instanceof Number) {
                    Number num = (Number)arg;
                    if (((Boolean)argsLoaded.m_14418_()).booleanValue()) {
                        throw LuaValues.badArgument((int)i, (String)"boolean", (String)"number");
                    }
                    limit = num.intValue();
                    argsLoaded.m_145023_((Object)true);
                    continue;
                }
                if (arg instanceof Boolean) {
                    Boolean boo = (Boolean)arg;
                    if (((Boolean)argsLoaded.m_14419_()).booleanValue()) {
                        throw LuaValues.badArgument((int)i, (String)"number", (String)"boolean");
                    }
                    filter = boo != false ? TraderData.LOGS_SETTINGS_FILTER : TraderData.LOGS_NORMAL_FILTER;
                    argsLoaded.m_145025_((Object)true);
                    continue;
                }
                throw LuaValues.badArgument((int)i, (String)"number or boolean", (String)arg.getClass().getSimpleName());
            }
        }
        List<Notification> notifications = ((TraderData)this.getTrader()).getNotifications((Predicate<Notification>)filter);
        if (limit <= 0) {
            limit = notifications.size();
        }
        ArrayList<LCLuaTable> result = new ArrayList<LCLuaTable>();
        for (int i = 0; i < limit && i < notifications.size(); ++i) {
            Notification not = notifications.get(i);
            LCLuaTable entry = new LCLuaTable();
            entry.put("Timestamp", not.getTimeStamp());
            entry.put("Count", not.getCount());
            ArrayList<String> lines = new ArrayList<String>();
            for (Component line : not.getMessageLines()) {
                lines.add(line.getString());
            }
            entry.put("Text", lines.toArray(String[]::new));
            result.add(entry);
        }
        return (LCLuaTable[])result.toArray(LCLuaTable[]::new);
    }

    public String getName() throws LuaException {
        return ((TraderData)this.getTrader()).getName().getString();
    }

    public boolean setName(IComputerAccess computer, IArguments args) throws LuaException {
        String newName = args.getString(0);
        if (this.hasPermissions(computer, "changeName")) {
            T trader;
            String oldName;
            if (newName.length() > 16) {
                newName = newName.substring(0, 16);
            }
            if (!(oldName = ((TraderData)(trader = this.getTrader())).getCustomName()).equals(newName)) {
                ((TraderData)trader).setCustomName(newName);
                ((TraderData)trader).pushLocalNotification(new ChangeNameNotification(this.getFakePlayer(computer), newName, oldName));
                return true;
            }
        }
        return false;
    }

    public LCLuaTable getIcon() throws LuaException {
        T t = this.getTrader();
        return LCLuaTable.fromTag(((TraderData)t).getCustomIcon().save());
    }

    public boolean setIcon(IComputerAccess computer, IArguments args) throws LuaException {
        if (this.hasPermissions(computer, "changeName")) {
            T trader = this.getTrader();
            Map table = args.getTable(0);
            CompoundTag tag = LCLuaTable.toTag(table);
            LightmansCurrency.LogDebug("Parsed table as Compound Tag\nTable: " + DebugUtil.debugMap(table) + "\nTag: " + tag.m_7916_());
            if (tag.m_128456_()) {
                return false;
            }
            IconData icon = IconData.load(tag);
            if (icon == null) {
                return false;
            }
            ((TraderData)trader).setCustomIcon(icon);
            ((TraderData)trader).pushLocalNotification(ChangeSettingNotification.dumb(this.getFakePlayer(computer), (Component)LCText.DATA_ENTRY_TRADER_ICON.get(new Object[0])));
            return true;
        }
        return false;
    }

    public boolean hasBankAccount() throws LuaException {
        return ((TraderData)this.getTrader()).hasBankAccount();
    }

    @Nullable
    public LCLuaTable getLinkedAccount() throws LuaException {
        if (!this.hasBankAccount()) {
            return null;
        }
        BankReference br = ((TraderData)this.getTrader()).getBankReference();
        LCLuaTable table = LCLuaTable.fromTag(br.save());
        if (br instanceof PlayerBankReference) {
            PlayerBankReference pbr = (PlayerBankReference)br;
            table.put("Player", pbr.getPlayer().getName(false));
        }
        return table;
    }

    public boolean setLinkedToBankAccount(IComputerAccess computer, IArguments args) throws LuaException {
        T trader;
        boolean linkedToBankAccount;
        boolean newState = args.getBoolean(0);
        if (this.hasPermissions(computer, "bankLink") && (linkedToBankAccount = ((TraderData)(trader = this.getTrader())).isLinkedToBank()) != newState) {
            if (newState && !((TraderData)trader).canLinkBankAccount()) {
                return false;
            }
            ((TraderData)trader).setLinkedToBank(newState);
            if (newState != ((TraderData)trader).isLinkedToBank()) {
                return false;
            }
            ((TraderData)trader).pushLocalNotification(ChangeSettingNotification.simple(this.getFakePlayer(computer), (Component)LCText.DATA_ENTRY_TRADER_BANK_LINK.get(new Object[0]), newState));
            return true;
        }
        return false;
    }

    public boolean showsSearchBox() throws LuaException {
        return ((TraderData)this.getTrader()).showSearchBox();
    }

    public boolean setShowsSearchBox(IComputerAccess computer, IArguments args) throws LuaException {
        T trader;
        boolean newState = args.getBoolean(0);
        if (this.hasPermissions(computer, "editSettings") && ((TraderData)(trader = this.getTrader())).alwaysShowSearchBox() != newState) {
            ((TraderData)trader).setAlwaysShowSearchBox(newState);
            ((TraderData)trader).pushLocalNotification(ChangeSettingNotification.simple(this.getFakePlayer(computer), (Component)LCText.DATA_ENTRY_TRADER_ALWAYS_SHOW_SEARCH_BOX.get(new Object[0]), newState));
            return true;
        }
        return false;
    }

    public boolean hasPushNotifications() throws LuaException {
        return ((TraderData)this.getTrader()).notificationsEnabled();
    }

    public boolean setPushNotifications(IComputerAccess computer, IArguments args) throws LuaException {
        T trader;
        boolean newState = args.getBoolean(0);
        if (this.hasPermissions(computer, "editSettings") && ((TraderData)(trader = this.getTrader())).notificationsEnabled() != newState) {
            ((TraderData)trader).setNotificationsEnabled(newState);
            ((TraderData)trader).pushLocalNotification(ChangeSettingNotification.simple(this.getFakePlayer(computer), (Component)LCText.DATA_ENTRY_TRADER_NOTIFICATIONS_ENABLED.get(new Object[0]), newState));
            return true;
        }
        return false;
    }

    public boolean hasChatNotifications() throws LuaException {
        return ((TraderData)this.getTrader()).notificationsToChat();
    }

    public boolean setChatNotifications(IComputerAccess computer, IArguments args) throws LuaException {
        T trader;
        boolean newState = args.getBoolean(0);
        if (this.hasPermissions(computer, "editSettings") && ((TraderData)(trader = this.getTrader())).notificationsToChat() != newState) {
            ((TraderData)trader).setNotificationsToChat(newState);
            ((TraderData)trader).pushLocalNotification(ChangeSettingNotification.simple(this.getFakePlayer(computer), (Component)LCText.DATA_ENTRY_TRADER_NOTIFICATIONS_TO_CHAT.get(new Object[0]), newState));
            return true;
        }
        return false;
    }

    public int teamNotificationLevel() throws LuaException {
        return ((TraderData)this.getTrader()).teamNotificationLevel();
    }

    public boolean setTeamNotificationLevel(IComputerAccess computer, IArguments args) throws LuaException {
        T trader;
        int newLevel = args.getInt(0);
        ArgumentHelpers.assertBetween((int)newLevel, (int)0, (int)2, (String)"Level is not in range (%s)");
        if (this.hasPermissions(computer, "editSettings") && ((TraderData)(trader = this.getTrader())).teamNotificationLevel() != newLevel) {
            ((TraderData)trader).setTeamNotificationLevel(newLevel);
            ((TraderData)trader).pushLocalNotification(ChangeSettingNotification.simple(this.getFakePlayer(computer), (Component)LCText.DATA_ENTRY_TRADER_TEAM_NOTIFICATION_LEVEL.get(new Object[0]), newLevel));
            return true;
        }
        return false;
    }

    public int tradeCount() throws LuaException {
        return ((TraderData)this.getTrader()).getTradeCount();
    }

    public int validTradeCount() throws LuaException {
        return ((TraderData)this.getTrader()).validTradeCount();
    }

    public int tradesWithStock() throws LuaException {
        return ((TraderData)this.getTrader()).tradesWithStock();
    }

    public int acceptableTaxRate() throws LuaException {
        return ((TraderData)this.getTrader()).getAcceptableTaxRate();
    }

    public boolean setAcceptableTaxRate(IComputerAccess computer, IArguments args) throws LuaException {
        T trader;
        int newValue = args.getInt(0);
        ArgumentHelpers.assertBetween((int)newValue, (int)0, (int)99, (String)"Tax Rate is not in range (%s)");
        if (this.hasPermissions(computer, "editSettings") && ((TraderData)(trader = this.getTrader())).getAcceptableTaxRate() != newValue) {
            int oldRate = ((TraderData)trader).getAcceptableTaxRate();
            ((TraderData)trader).setAcceptableTaxRate(newValue);
            ((TraderData)trader).pushLocalNotification(ChangeSettingNotification.advanced(this.getFakePlayer(computer), (Component)LCText.DATA_ENTRY_TRADER_TAXES_RATE.get(new Object[0]), newValue, oldRate));
            return true;
        }
        return false;
    }

    public int currentTaxRate() throws LuaException {
        return ((TraderData)this.getTrader()).getTotalTaxPercentage();
    }

    public LCLuaTable getWorldPosition() throws LuaException {
        return LCLuaTable.fromTag(((TraderData)this.getTrader()).getWorldPosition().save());
    }

    public String[] getCurrentUsers() throws LuaException {
        ArrayList<String> users = new ArrayList<String>();
        for (Player user : ((TraderData)this.getTrader()).getUsers()) {
            users.add(user.m_7755_().getString());
        }
        return (String[])users.toArray(String[]::new);
    }

    public Object getUpgradeSlots(IComputerAccess computer) {
        return TraderPeripheral.wrapContainer(computer, () -> this.hasPermissions(computer, "openStorage"), this::safeGetUpgradeContainer);
    }

    private Container safeGetUpgradeContainer() {
        T trader = this.safeGetTrader();
        if (trader != null) {
            return ((TraderData)trader).getUpgrades();
        }
        return null;
    }

    public void preTradeEvent(TradeEvent.PreTradeEvent event) {
        T trader = this.safeGetTrader();
        if (event.getTrader() == trader) {
            try {
                LCPeripheral tradeWrapper = this.wrapTrade(event.getTrade());
                LCLuaTable player = LCLuaTable.fromPlayer(event.getPlayerReference());
                boolean canceled = event.isCanceled();
                this.queueEvent("lc_trade_pre", (IComputerAccess computer) -> new Object[]{this.asTable((IComputerAccess)computer), event.getTradeIndex(), tradeWrapper.asTable((IComputerAccess)computer), player, canceled});
            }
            catch (LuaException luaException) {
                // empty catch block
            }
        }
    }

    private void postTradeEvent(TradeEvent.PostTradeEvent event) {
        T trader = this.safeGetTrader();
        if (event.getTrader() == trader) {
            try {
                LCPeripheral tradeWrapper = this.wrapTrade(event.getTrade());
                LCLuaTable player = LCLuaTable.fromPlayer(event.getPlayerReference());
                LCLuaTable finalPrice = LCLuaTable.fromMoney(event.getPricePaid());
                LCLuaTable taxesPaid = LCLuaTable.fromMoney(event.getTaxesPaid());
                this.queueEvent("lc_trade", (IComputerAccess computer) -> new Object[]{this.asTable((IComputerAccess)computer), event.getTradeIndex(), tradeWrapper.asTable((IComputerAccess)computer), player, finalPrice, taxesPaid});
            }
            catch (LuaException luaException) {
                // empty catch block
            }
        }
    }

    private Object getTrade(IComputerAccess computer, IArguments args) throws LuaException {
        int slot = args.getInt(0);
        T trader = this.getTrader();
        ArgumentHelpers.assertBetween((int)slot, (int)1, (int)((TraderData)trader).getTradeCount(), (String)"Trade Slot is out of bounds (%s)");
        return this.wrapTrade(((TraderData)trader).getTrade(slot - 1)).asTable(computer);
    }

    @Override
    protected void registerMethods(LCPeripheralMethod.Registration registration) {
        registration.register(LCPeripheralMethod.builder("isValid").simple(this::isValid));
        registration.register(LCPeripheralMethod.builder("getID").simple(this::getID));
        registration.register(LCPeripheralMethod.builder("isVisibleOnNetwork").simple(this::isVisibleOnNetwork));
        registration.register(LCPeripheralMethod.builder("isCreative").simple(this::isCreative));
        registration.register(LCPeripheralMethod.builder("isPersistent").simple(this::isPersistent));
        registration.register(LCPeripheralMethod.builder("getOwner").simple(this::getOwner));
        registration.register(LCPeripheralMethod.builder("getOwnerName").simple(this::getOwnerName));
        registration.register(LCPeripheralMethod.builder("getStats").simple(this::getStats));
        registration.register(LCPeripheralMethod.builder("getAllies").simpleArray(this::getAllies));
        registration.register(LCPeripheralMethod.builder("addAlly").withContext(this::addAlly));
        registration.register(LCPeripheralMethod.builder("removeAlly").withContext(this::removeAlly));
        registration.register(LCPeripheralMethod.builder("getAllyPermissions").simple(this::getAllyPermissions));
        registration.register(LCPeripheralMethod.builder("getAllyPermissionLevel").withArgs(this::getAllyPermissionLevel));
        registration.register(LCPeripheralMethod.builder("setAllyPermissionLevel").withContext(this::setAllyPermissionLevel));
        registration.register(LCPeripheralMethod.builder("getPlayerPermissionLevel").withArgs(this::getPlayerPermissionLevel));
        registration.register(LCPeripheralMethod.builder("getMyPermissionLevel").withContext(this::getMyPermissionLevel));
        registration.register(LCPeripheralMethod.builder("getLogs").withArgsArray(this::getLogs));
        registration.register(LCPeripheralMethod.builder("getName").simple(this::getName));
        registration.register(LCPeripheralMethod.builder("setName").withContext(this::setName));
        registration.register(LCPeripheralMethod.builder("getIcon").simple(this::getIcon));
        registration.register(LCPeripheralMethod.builder("setIcon").withContext(this::setIcon));
        registration.register(LCPeripheralMethod.builder("hasBankAccount").simple(this::hasBankAccount));
        registration.register(LCPeripheralMethod.builder("getLinkedAccount").simple(this::getLinkedAccount));
        registration.register(LCPeripheralMethod.builder("setLinkedToBankAccount").withContext(this::setLinkedToBankAccount));
        registration.register(LCPeripheralMethod.builder("showsSearchBox").simple(this::showsSearchBox));
        registration.register(LCPeripheralMethod.builder("setShowsSearchBox").withContext(this::setShowsSearchBox));
        registration.register(LCPeripheralMethod.builder("hasPushNotifications").simple(this::hasPushNotifications));
        registration.register(LCPeripheralMethod.builder("setPushNotification").withContext(this::setPushNotifications));
        registration.register(LCPeripheralMethod.builder("hasChatNotifications").simple(this::hasChatNotifications));
        registration.register(LCPeripheralMethod.builder("setChatNotifications").withContext(this::setChatNotifications));
        registration.register(LCPeripheralMethod.builder("teamNotificationLevel").simple(this::teamNotificationLevel));
        registration.register(LCPeripheralMethod.builder("setTeamNotificationLevel").withContext(this::setTeamNotificationLevel));
        registration.register(LCPeripheralMethod.builder("tradeCount").simple(this::tradeCount));
        registration.register(LCPeripheralMethod.builder("validTradeCount").simple(this::validTradeCount));
        registration.register(LCPeripheralMethod.builder("tradesWithStock").simple(this::tradesWithStock));
        registration.register(LCPeripheralMethod.builder("acceptableTaxRate").simple(this::acceptableTaxRate));
        registration.register(LCPeripheralMethod.builder("setAcceptableTaxRate").withContext(this::setAcceptableTaxRate));
        registration.register(LCPeripheralMethod.builder("currentTaxRate").simple(this::currentTaxRate));
        registration.register(LCPeripheralMethod.builder("getWorldPosition").simple(this::getWorldPosition));
        registration.register(LCPeripheralMethod.builder("getCurrentUsers").simpleArray(this::getCurrentUsers));
        registration.register(LCPeripheralMethod.builder("getUpgrades").withContextOnly(this::getUpgradeSlots));
    }

    protected final void registerGetTrade(LCPeripheralMethod.Registration registration) {
        registration.register(LCPeripheralMethod.builder("getTrade").withContext(this::getTrade));
    }

    private static class Simple
    extends TraderPeripheral<TraderBlockEntity<TraderData>, TraderData> {
        private Simple(TraderBlockEntity<TraderData> blockEntity) {
            super(blockEntity);
        }

        private Simple(TraderData trader) {
            super(trader);
        }

        public String getType() {
            return TraderPeripheral.BASE_TYPE;
        }

        @Override
        public Set<String> getAdditionalTypes() {
            return Set.of();
        }

        @Override
        @Nullable
        protected LCPeripheral wrapTrade(TradeData trade) throws LuaException {
            int index = ((TraderData)this.getTrader()).indexOfTrade(trade);
            return TradeWrapper.createSimple(() -> {
                Object trader = this.safeGetTrader();
                if (trader != null && index >= 0 && index < ((TraderData)trader).getTradeCount()) {
                    return ((TraderData)trader).getTrade(index);
                }
                return null;
            }, this::safeGetTrader);
        }
    }
}

