/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.curios;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.gamerule.ModGameRules;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.capability.CurioItemCapability;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LCCuriosInternal {
    public static final String WALLET_SLOT = "wallet";

    @Nullable
    private static ICuriosItemHandler getCurios(LivingEntity entity) {
        return (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler(entity).orElse(null);
    }

    @Nullable
    private static ICurioStacksHandler getStacks(LivingEntity entity, String slot) {
        ICuriosItemHandler handler = LCCuriosInternal.getCurios(entity);
        if (handler != null) {
            return handler.getStacksHandler(slot).orElse(null);
        }
        return null;
    }

    public static boolean hasWalletSlot(LivingEntity entity) {
        try {
            ICurioStacksHandler handler = LCCuriosInternal.getStacks(entity, WALLET_SLOT);
            return handler != null && handler.getSlots() > 0;
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error with Curios Integration!", t);
            return false;
        }
    }

    public static ItemStack getCuriosWalletItem(LivingEntity entity) {
        try {
            ICurioStacksHandler handler = LCCuriosInternal.getStacks(entity, WALLET_SLOT);
            if (handler != null && handler.getSlots() > 0) {
                return handler.getStacks().getStackInSlot(0);
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error with Curios Integration!", t);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getVisibleCuriosWalletItem(LivingEntity entity) {
        try {
            ICurioStacksHandler handler = LCCuriosInternal.getStacks(entity, WALLET_SLOT);
            if (handler != null && handler.getSlots() > 0) {
                ItemStack cosmetic = ItemStack.f_41583_;
                if (handler.getCosmeticStacks().getSlots() > 0) {
                    cosmetic = handler.getCosmeticStacks().getStackInSlot(0);
                }
                return cosmetic.m_41619_() ? handler.getStacks().getStackInSlot(0) : cosmetic;
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error with Curios Integration!", t);
        }
        return ItemStack.f_41583_;
    }

    public static void setCuriosWalletItem(LivingEntity entity, ItemStack item) {
        try {
            ICurioStacksHandler handler = LCCuriosInternal.getStacks(entity, WALLET_SLOT);
            if (handler != null && handler.getSlots() > 0) {
                handler.getStacks().setStackInSlot(0, item);
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error with Curios Integration!", t);
        }
    }

    public static boolean getCuriosWalletVisibility(LivingEntity entity) {
        try {
            ICurioStacksHandler handler = LCCuriosInternal.getStacks(entity, WALLET_SLOT);
            if (handler != null && handler.getSlots() > 0) {
                return (Boolean)handler.getRenders().get(0);
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error with Curios Integration!", t);
        }
        return false;
    }

    public static boolean hasItem(LivingEntity entity, Predicate<ItemStack> check) {
        try {
            ICuriosItemHandler handler = LCCuriosInternal.getCurios(entity);
            if (handler != null) {
                for (ICurioStacksHandler stacks : handler.getCurios().values()) {
                    IDynamicStackHandler sh = stacks.getStacks();
                    for (int i = 0; i < sh.getSlots(); ++i) {
                        if (!check.test(sh.getStackInSlot(i))) continue;
                        return true;
                    }
                }
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error with Curios Integration!", t);
        }
        return false;
    }

    @Nullable
    public static Item lookupItem(LivingEntity entity, Predicate<ItemStack> test) {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        LCCuriosInternal.hasItem(entity, stack -> {
            if (test.test((ItemStack)stack)) {
                result.set(stack.m_41720_());
                return true;
            }
            return false;
        });
        return result.get();
    }

    @Nullable
    public static ItemStack getRandomItem(LivingEntity entity, Predicate<ItemStack> check) {
        try {
            ICuriosItemHandler handler = LCCuriosInternal.getCurios(entity);
            if (handler != null) {
                ArrayList<ItemStack> options = new ArrayList<ItemStack>();
                for (ICurioStacksHandler stacks : handler.getCurios().values()) {
                    IDynamicStackHandler sh = stacks.getStacks();
                    for (int i = 0; i < sh.getSlots(); ++i) {
                        ItemStack stack = sh.getStackInSlot(i);
                        if (!check.test(stack)) continue;
                        options.add(stack);
                    }
                }
                if (!options.isEmpty()) {
                    return (ItemStack)options.get(entity.m_217043_().m_188503_(options.size()));
                }
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error with Curios Integration!", t);
        }
        return null;
    }

    @Nullable
    public static ICapabilityProvider createWalletProvider(final ItemStack stack) {
        try {
            return CurioItemCapability.createProvider((ICurio)new ICurio(){

                public ItemStack getStack() {
                    return stack;
                }

                public ICurio.SoundInfo getEquipSound(SlotContext context) {
                    return new ICurio.SoundInfo(SoundEvents.f_11678_, 1.0f, 1.0f);
                }

                public boolean canEquipFromUse(SlotContext context) {
                    return false;
                }

                public boolean canUnequip(SlotContext context) {
                    LivingEntity livingEntity = context.entity();
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        livingEntity = player.f_36096_;
                        if (livingEntity instanceof WalletMenuBase) {
                            WalletMenuBase menu = (WalletMenuBase)livingEntity;
                            return !menu.isEquippedWallet();
                        }
                    }
                    return true;
                }

                public ICurio.DropRule getDropRule(SlotContext context, DamageSource source, int lootingLevel, boolean recentlyHit) {
                    if (ModGameRules.safeGetCustomBool(context.entity().m_9236_(), ModGameRules.KEEP_WALLET, false)) {
                        return ICurio.DropRule.ALWAYS_KEEP;
                    }
                    return ICurio.DropRule.DEFAULT;
                }
            });
        }
        catch (Throwable t) {
            return null;
        }
    }
}

