/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.config;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SPacketEditConfig
extends ServerToClientPacket {
    public static final CustomPacket.Handler<SPacketEditConfig> HANDLER = new H();
    private final ResourceLocation fileID;
    private final String option;
    private final String input;

    public SPacketEditConfig(ResourceLocation fileID, String option, String input) {
        this.fileID = fileID;
        this.option = option;
        this.input = input;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.fileID);
        buffer.m_130070_(this.option);
        buffer.writeInt(this.input.length());
        buffer.m_130072_(this.input, this.input.length());
    }

    private static class H
    extends CustomPacket.Handler<SPacketEditConfig> {
        private H() {
        }

        @Override
        public SPacketEditConfig decode(FriendlyByteBuf buffer) {
            ResourceLocation fileID = buffer.m_130281_();
            String option = buffer.m_130277_();
            int inputLength = buffer.readInt();
            return new SPacketEditConfig(fileID, option, buffer.m_130136_(inputLength));
        }

        @Override
        protected void handle(SPacketEditConfig message, Player player) {
            ConfigFile file = ConfigFile.lookupFile(message.fileID);
            if (file != null && file.isClientOnly()) {
                Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
                if (optionMap.containsKey(message.option)) {
                    ConfigOption<?> option = optionMap.get(message.option);
                    Pair<Boolean, ConfigParsingException> result = option.load(message.input, ConfigOption.LoadSource.COMMAND);
                    if (!((Boolean)result.getFirst()).booleanValue()) {
                        LightmansCurrency.getProxy().sendClientMessage((Component)LCText.COMMAND_CONFIG_EDIT_FAIL_PARSE.get(((ConfigParsingException)result.getSecond()).getMessage()).m_130940_(ChatFormatting.RED));
                        return;
                    }
                    LightmansCurrency.getProxy().sendClientMessage((Component)LCText.COMMAND_CONFIG_EDIT_SUCCESS.get(message.option, message.input));
                } else {
                    LightmansCurrency.getProxy().sendClientMessage((Component)LCText.COMMAND_CONFIG_FAIL_MISSING.get(message.option).m_130940_(ChatFormatting.RED));
                }
            }
        }
    }
}

