/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.menus.validation.EasyMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.IValidatedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkHooks;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CPacketOpenTrades
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketOpenTrades> HANDLER = new H();
    private final long traderID;

    public CPacketOpenTrades(long traderID) {
        this.traderID = traderID;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeLong(this.traderID);
    }

    private static class H
    extends CustomPacket.Handler<CPacketOpenTrades> {
        private H() {
        }

        @Override
        public CPacketOpenTrades decode(FriendlyByteBuf buffer) {
            return new CPacketOpenTrades(buffer.readLong());
        }

        @Override
        protected void handle(CPacketOpenTrades message, Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof IValidatedMenu) {
                IValidatedMenu tm = (IValidatedMenu)abstractContainerMenu;
                MenuValidator validator = tm.getValidator();
                if (message.traderID < 0L && player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)TraderData.getTraderMenuForAllNetworkTraders(validator), EasyMenu.encoder(validator));
                } else {
                    TraderData data = TraderAPI.getApi().GetTrader(false, message.traderID);
                    if (data != null) {
                        data.openTraderMenu(player, validator);
                    }
                }
            }
        }
    }
}

