/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.wallet;

import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CPacketOpenWalletBank
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketOpenWalletBank> HANDLER = new H();
    private final int walletStackIndex;

    public CPacketOpenWalletBank(int walletStackIndex) {
        this.walletStackIndex = walletStackIndex;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.walletStackIndex);
    }

    private static class H
    extends CustomPacket.Handler<CPacketOpenWalletBank> {
        private H() {
        }

        @Override
        public CPacketOpenWalletBank decode(FriendlyByteBuf buffer) {
            return new CPacketOpenWalletBank(buffer.readInt());
        }

        @Override
        protected void handle(CPacketOpenWalletBank message, Player player) {
            WalletMenuBase.SafeOpenWalletBankMenu(player, message.walletStackIndex);
        }
    }
}

