/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.proxy;

import com.google.common.base.Suppliers;
import com.mojang.authlib.GameProfile;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.ConfigSelectionScreen;
import io.github.lightman314.lightmanscurrency.api.events.NotificationEvent;
import io.github.lightman314.lightmanscurrency.api.events.client.RegisterVariantPropertiesEvent;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ATMCardScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.NetworkTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.NotificationScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.VariantSelectScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.config.MasterCoinListConfigOption;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.CoinChestScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.EjectionRecoveryScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.GachaMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ItemFilterScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MintScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.PlayerTradeScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.SlotMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TaxCollectorScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TicketStationScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletBankScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ItemEditWidget;
import io.github.lightman314.lightmanscurrency.client.renderer.LCItemRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.AuctionStandBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.BookTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.CoinChestRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.FreezerTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.GachaMachineBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.SlotMachineBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.BookRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.renderers.EnchantedBookRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.renderers.NormalBookRenderer;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.RotationHandler;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperties;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.capability.event_unlocks.CapabilityEventUnlocks;
import io.github.lightman314.lightmanscurrency.common.capability.event_unlocks.IEventUnlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.data.types.NotificationDataCache;
import io.github.lightman314.lightmanscurrency.common.items.AncientCoinItem;
import io.github.lightman314.lightmanscurrency.common.items.MoneyBagItem;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.items.ancient_coins.AncientCoinType;
import io.github.lightman314.lightmanscurrency.common.menus.PlayerTradeMenu;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.playertrading.ClientPlayerTrade;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.integration.curios.client.LCCuriosClient;
import io.github.lightman314.lightmanscurrency.proxy.CommonProxy;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ClientProxy
extends CommonProxy {
    private long timeOffset = 0L;
    private final Supplier<CoinChestBlockEntity> coinChestBE = Suppliers.memoize(() -> new CoinChestBlockEntity(BlockPos.f_121853_, ((Block)ModBlocks.COIN_CHEST.get()).m_49966_()));

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerVariantProperties);
        FMLModContainer container = FMLJavaModLoadingContext.get().getContainer();
        container.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, (Supplier)Suppliers.memoize(() -> ConfigSelectionScreen.mixedFactory((ModContainer)container, LCConfig.CLIENT, LCConfig.COMMON, LCConfig.SERVER, MasterCoinListConfigOption.INSTANCE)));
    }

    @Override
    public void setupClient() {
        ConfigFile.loadClientFiles(ConfigFile.LoadPhase.SETUP);
        MenuScreens.m_96206_(ModMenus.ATM.get(), ATMScreen::new);
        MenuScreens.m_96206_(ModMenus.MINT.get(), MintScreen::new);
        MenuScreens.m_96206_(ModMenus.NETWORK_TERMINAL.get(), NetworkTerminalScreen::new);
        MenuScreens.m_96206_(ModMenus.TRADER.get(), TraderScreen::new);
        MenuScreens.m_96206_(ModMenus.TRADER_BLOCK.get(), TraderScreen::new);
        MenuScreens.m_96206_(ModMenus.TRADER_NETWORK_ALL.get(), TraderScreen::new);
        MenuScreens.m_96206_(ModMenus.TRADER_STORAGE.get(), TraderStorageScreen::new);
        MenuScreens.m_96206_(ModMenus.SLOT_MACHINE.get(), SlotMachineScreen::new);
        MenuScreens.m_96206_(ModMenus.GACHA_MACHINE.get(), GachaMachineScreen::new);
        MenuScreens.m_96206_(ModMenus.WALLET.get(), WalletScreen::new);
        MenuScreens.m_96206_(ModMenus.WALLET_BANK.get(), WalletBankScreen::new);
        MenuScreens.m_96206_(ModMenus.TICKET_MACHINE.get(), TicketStationScreen::new);
        MenuScreens.m_96206_(ModMenus.TRADER_INTERFACE.get(), TraderInterfaceScreen::new);
        MenuScreens.m_96206_(ModMenus.EJECTION_RECOVERY.get(), EjectionRecoveryScreen::new);
        MenuScreens.m_96206_(ModMenus.PLAYER_TRADE.get(), PlayerTradeScreen::new);
        MenuScreens.m_96206_(ModMenus.COIN_CHEST.get(), CoinChestScreen::new);
        MenuScreens.m_96206_(ModMenus.TAX_COLLECTOR.get(), TaxCollectorScreen::new);
        MenuScreens.m_96206_(ModMenus.TEAM_MANAGEMENT.get(), TeamManagerScreen::new);
        MenuScreens.m_96206_(ModMenus.NOTIFICATIONS.get(), NotificationScreen::new);
        MenuScreens.m_96206_(ModMenus.ATM_CARD.get(), ATMCardScreen::new);
        MenuScreens.m_96206_(ModMenus.VARIANT_SELECT.get(), VariantSelectScreen::new);
        MenuScreens.m_96206_(ModMenus.ITEM_FILTER.get(), ItemFilterScreen::new);
        BlockEntityRenderers.m_173590_(ModBlockEntities.ITEM_TRADER.get(), ItemTraderBlockEntityRenderer::create);
        BlockEntityRenderers.m_173590_(ModBlockEntities.FREEZER_TRADER.get(), FreezerTraderBlockEntityRenderer::create);
        BlockEntityRenderers.m_173590_(ModBlockEntities.SLOT_MACHINE_TRADER.get(), SlotMachineBlockEntityRenderer::create);
        BlockEntityRenderers.m_173590_(ModBlockEntities.BOOK_TRADER.get(), BookTraderBlockEntityRenderer::create);
        BlockEntityRenderers.m_173590_(ModBlockEntities.AUCTION_STAND.get(), AuctionStandBlockEntityRenderer::create);
        BlockEntityRenderers.m_173590_(ModBlockEntities.COIN_CHEST.get(), CoinChestRenderer::new);
        BlockEntityRenderers.m_173590_(ModBlockEntities.GACHA_MACHINE.get(), GachaMachineBlockEntityRenderer::create);
        ItemEditWidget.BlacklistCreativeTabs(CreativeModeTabs.f_256917_, CreativeModeTabs.f_257039_, CreativeModeTabs.f_256750_, CreativeModeTabs.f_256837_);
        ItemEditWidget.BlacklistItem(s -> s.m_41720_() instanceof TicketItem);
        ItemEditWidget.AddExtraItemAfter(new ItemStack((ItemLike)Items.f_42615_), Items.f_42614_);
        BookRenderer.register(NormalBookRenderer.GENERATOR);
        BookRenderer.register(EnchantedBookRenderer.GENERATOR);
        LCItemRenderer.registerBlockEntitySource(this::checkForCoinChest);
        ItemProperties.register((Item)ModItems.COIN_ANCIENT.get(), (ResourceLocation)AncientCoinItem.PROPERTY, (stack, level, player, seed) -> {
            AncientCoinType type = AncientCoinItem.getAncientCoinType(stack);
            return type == null ? 0.0f : (float)type.ordinal() + 1.0f;
        });
        ItemProperties.register((Item)((Block)ModBlocks.MONEY_BAG.get()).m_5456_(), (ResourceLocation)MoneyBagItem.PROPERTY, (stack, level, player, seed) -> MoneyBagItem.getSize(stack));
        if (LCCurios.isLoaded()) {
            LCCuriosClient.registerRenderLayers();
        }
        RotationHandler.setup();
    }

    private void registerVariantProperties(RegisterVariantPropertiesEvent event) {
        event.register(VersionUtil.lcResource("item_position_data"), VariantProperties.ITEM_POSITION_DATA);
        event.register(VersionUtil.lcResource("freezer_door"), VariantProperties.FREEZER_DOOR_DATA);
        event.register(VersionUtil.lcResource("input_display_offset"), VariantProperties.INPUT_DISPLAY_OFFSET);
        event.register(VersionUtil.lcResource("tooltip_info"), VariantProperties.TOOLTIP_INFO);
        event.register(VersionUtil.lcResource("show_in_creative"), VariantProperties.SHOW_IN_CREATIVE);
        event.register(VersionUtil.lcResource("hidden"), VariantProperties.HIDDEN);
    }

    private BlockEntity checkForCoinChest(Block block) {
        if (block == ModBlocks.COIN_CHEST.get()) {
            return this.coinChestBE.get();
        }
        return null;
    }

    @Override
    public void receiveNotification(Notification notification) {
        Minecraft mc = Minecraft.m_91087_();
        assert (mc.f_91074_ != null);
        if (MinecraftForge.EVENT_BUS.post((Event)new NotificationEvent.NotificationReceivedOnClient(mc.f_91074_.m_20148_(), NotificationDataCache.TYPE.get(true).getNotifications((Player)mc.f_91074_), notification))) {
            return;
        }
        if (((Boolean)LCConfig.CLIENT.pushNotificationsToChat.get()).booleanValue()) {
            for (Component line : notification.getChatMessage()) {
                mc.f_91065_.m_93076_().m_93785_(line);
            }
        }
    }

    @Override
    public long getTimeDesync() {
        return this.timeOffset;
    }

    @Override
    public void setTimeDesync(long serverTime) {
        this.timeOffset = serverTime - System.currentTimeMillis();
        this.timeOffset = this.timeOffset / 1000L * 1000L;
        if (this.timeOffset < 10000L) {
            this.timeOffset = 0L;
        }
    }

    @Override
    public void loadAdminPlayers(List<UUID> serverAdminList) {
        LCAdminMode.loadAdminPlayers(serverAdminList);
    }

    @Override
    public void playCoinSound() {
        if (((Boolean)LCConfig.CLIENT.moneyMendingClink.get()).booleanValue()) {
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)ModSounds.COINS_CLINKING.get(), (float)1.0f, (float)0.4f));
        }
    }

    @Override
    @Nullable
    public Level getDimension(boolean isClient, ResourceKey<Level> type) {
        if (isClient) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && mc.f_91073_.m_46472_().m_135782_().equals((Object)type.m_135782_())) {
                return mc.f_91073_;
            }
            return null;
        }
        return super.getDimension(isClient, type);
    }

    @Override
    public Level safeGetDummyLevel() {
        Level level = this.getDummyLevelFromServer();
        if (level == null) {
            level = Minecraft.m_91087_().f_91073_;
        }
        if (level != null) {
            return level;
        }
        LightmansCurrency.LogWarning("Could not get dummy level from client, as there is no active level!");
        return null;
    }

    @Override
    public boolean getHasPermissionsSetting() {
        Player player = this.getLocalPlayer();
        if (player == null) {
            return false;
        }
        return (Boolean)Minecraft.m_91087_().f_91066_.m_257871_().m_231551_() != false && player.m_36337_();
    }

    @Override
    public void loadPlayerTrade(ClientPlayerTrade trade) {
        Minecraft mc = Minecraft.m_91087_();
        AbstractContainerMenu abstractContainerMenu = mc.f_91074_.f_36096_;
        if (abstractContainerMenu instanceof PlayerTradeMenu) {
            PlayerTradeMenu menu = (PlayerTradeMenu)abstractContainerMenu;
            menu.reloadTrade(trade);
        }
    }

    @Override
    public void syncEventUnlocks(List<String> unlocksList) {
        Minecraft mc = Minecraft.m_91087_();
        IEventUnlocks unlocks = CapabilityEventUnlocks.getCapability((Player)mc.f_91074_);
        if (unlocks != null) {
            unlocks.sync(unlocksList);
        }
    }

    @Override
    public void sendClientMessage(Component message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.m_213846_(message);
        }
    }

    @Override
    public List<GameProfile> getPlayerList(boolean logicalClient) {
        if (!logicalClient) {
            return super.getPlayerList(logicalClient);
        }
        return Minecraft.m_91087_().m_91403_().m_105142_().stream().map(PlayerInfo::m_105312_).toList();
    }

    @Override
    public boolean isSelf(Player player) {
        return player == Minecraft.m_91087_().f_91074_;
    }

    @Override
    public Player getLocalPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }
}

