/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.holder_sets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.event.ConfigEvent;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.builtin.ItemListOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.extensions.IHolderSetExtension;
import net.neoforged.neoforge.registries.holdersets.HolderSetType;
import net.neoforged.neoforge.registries.holdersets.ICustomHolderSet;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@EventBusSubscriber
public class ItemListOptionSet
implements ICustomHolderSet<Item> {
    private static final Map<Pair<ResourceLocation, String>, ItemListOptionSet> setCache = new HashMap<Pair<ResourceLocation, String>, ItemListOptionSet>();
    public static final HolderSetType TYPE = new Type();
    private final List<Runnable> invalidationListeners = new ArrayList<Runnable>();
    private boolean registerListener = true;
    private List<Holder<Item>> cache = null;
    private final ResourceLocation fileID;
    private final String option;

    private void flagAsChanged() {
        this.cache = null;
        this.invalidationListeners.forEach(Runnable::run);
    }

    @Nullable
    private ItemListOption getOption() {
        ConfigOption<?> configOption;
        ConfigFile file = ConfigFile.lookupFile(this.fileID);
        if (file != null && (configOption = file.getAllOptions().get(this.option)) instanceof ItemListOption) {
            ItemListOption o = (ItemListOption)configOption;
            return o;
        }
        return null;
    }

    private List<Holder<Item>> getItems() {
        if (this.cache == null) {
            ItemListOption o = this.getOption();
            if (o == null || !o.isLoaded()) {
                return new ArrayList<Holder<Item>>();
            }
            if (this.registerListener) {
                o.addListener(i -> this.flagAsChanged());
                this.registerListener = false;
            }
            ArrayList<Holder> temp = new ArrayList<Holder>();
            for (Item item : (List)o.get()) {
                temp.add(BuiltInRegistries.ITEM.wrapAsHolder((Object)item));
            }
            this.cache = ImmutableList.copyOf(temp);
        }
        return this.cache;
    }

    private ItemListOptionSet(ResourceLocation fileID, String optionKey) {
        this.fileID = fileID;
        this.option = optionKey;
    }

    public static ItemListOptionSet create(ResourceLocation fileID, String optionKey) {
        Pair key = Pair.of((Object)fileID, (Object)optionKey);
        if (!setCache.containsKey(key)) {
            setCache.put((Pair<ResourceLocation, String>)key, new ItemListOptionSet(fileID, optionKey));
        }
        return setCache.get(key);
    }

    public static ItemListOptionSet create(ItemListOption option) {
        Object path = null;
        ConfigFile file = option.getFile();
        if (file == null) {
            throw new IllegalArgumentException("Config Option was not attached to a config file!");
        }
        String fullKey = option.getFullName();
        if (fullKey == null) {
            throw new IllegalArgumentException("Config Option was not a member of the config file!");
        }
        return ItemListOptionSet.create(file.getFileID(), fullKey);
    }

    public Stream<Holder<Item>> stream() {
        return this.getItems().stream();
    }

    public int size() {
        return this.getItems().size();
    }

    public Either<TagKey<Item>, List<Holder<Item>>> unwrap() {
        return Either.right(this.getItems());
    }

    public Optional<Holder<Item>> getRandomElement(RandomSource random) {
        List<Holder<Item>> list = this.getItems();
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(random.nextInt(list.size())));
    }

    public Holder<Item> get(int index) {
        return this.getItems().get(index);
    }

    public boolean contains(Holder<Item> holder) {
        return this.getItems().contains(holder);
    }

    public boolean canSerializeIn(HolderOwner<Item> owner) {
        return true;
    }

    public Optional<TagKey<Item>> unwrapKey() {
        return Optional.empty();
    }

    public Iterator<Holder<Item>> iterator() {
        return this.getItems().iterator();
    }

    public void addInvalidationListener(Runnable runnable) {
        this.invalidationListeners.add(runnable);
    }

    public HolderSetType type() {
        return TYPE;
    }

    public IHolderSetExtension.SerializationType serializationType() {
        return IHolderSetExtension.SerializationType.UNKNOWN;
    }

    @SubscribeEvent
    public static void configReloaded(ConfigEvent.ConfigReloadedEvent.Post event) {
        for (ItemListOptionSet set : setCache.values()) {
            if (set.fileID != event.getConfig().getFileID()) continue;
            set.flagAsChanged();
        }
    }

    @SubscribeEvent
    public static void configSynced(ConfigEvent.ConfigReceivedSyncDataEvent.Post event) {
        for (ItemListOptionSet set : setCache.values()) {
            if (set.fileID != event.getConfig().getFileID()) continue;
            set.flagAsChanged();
        }
    }

    private static class Type
    implements HolderSetType {
        private static final MapCodec<ItemListOptionSet> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("fileID").forGetter(s -> s.fileID), (App)Codec.STRING.fieldOf("option").forGetter(s -> s.option)).apply((Applicative)builder, ItemListOptionSet::create));
        private static final StreamCodec<RegistryFriendlyByteBuf, ItemListOptionSet> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, s -> s.fileID, (StreamCodec)ByteBufCodecs.STRING_UTF8, s -> s.option, ItemListOptionSet::create);

        private Type() {
        }

        private MapCodec<? extends ICustomHolderSet<?>> unsafeCodec() {
            return CODEC;
        }

        private StreamCodec<RegistryFriendlyByteBuf, ? extends ICustomHolderSet<?>> unsafeStream() {
            return STREAM_CODEC;
        }

        public <T> MapCodec<? extends ICustomHolderSet<T>> makeCodec(ResourceKey<? extends Registry<T>> registryKey, Codec<Holder<T>> holderCodec, boolean forceList) {
            return this.isItem(registryKey) ? this.unsafeCodec() : MapCodec.unit(new EmptySet(this));
        }

        public <T> StreamCodec<RegistryFriendlyByteBuf, ? extends ICustomHolderSet<T>> makeStreamCodec(ResourceKey<? extends Registry<T>> registryKey) {
            return this.isItem(registryKey) ? this.unsafeStream() : StreamCodec.unit(new EmptySet(this));
        }

        private boolean isItem(ResourceKey<? extends Registry<?>> key) {
            return key == BuiltInRegistries.ITEM.key();
        }
    }

    private static class EmptySet<T>
    implements ICustomHolderSet<T> {
        private final Type type;

        private EmptySet(Type type) {
            this.type = type;
        }

        public HolderSetType type() {
            return this.type;
        }

        public Stream<Holder<T>> stream() {
            return Stream.empty();
        }

        public int size() {
            return 0;
        }

        public Either<TagKey<T>, List<Holder<T>>> unwrap() {
            return Either.right((Object)ImmutableList.of());
        }

        public Optional<Holder<T>> getRandomElement(RandomSource random) {
            return Optional.empty();
        }

        public Holder<T> get(int index) {
            return null;
        }

        public boolean contains(Holder<T> holder) {
            return false;
        }

        public boolean canSerializeIn(HolderOwner<T> owner) {
            return false;
        }

        public Optional<TagKey<T>> unwrapKey() {
            return Optional.empty();
        }

        public Iterator<Holder<T>> iterator() {
            return this.stream().iterator();
        }
    }
}

