/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.basic;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnumOption<T extends Enum<T>>
extends ConfigOption<T> {
    private final ConfigParser<T> parser;
    public final Class<T> clazz;

    public static <T extends Enum<T>> ConfigParser<T> buildParser(Class<T> clazz) {
        return new EnumParser<T>(clazz);
    }

    protected EnumOption(Supplier<T> defaultValue, Class<T> clazz) {
        super(defaultValue);
        this.parser = EnumOption.buildParser(clazz);
        this.clazz = clazz;
    }

    @Override
    protected ConfigParser<T> getParser() {
        return this.parser;
    }

    @Override
    protected List<String> bonusComments() {
        return Lists.newArrayList((Object[])new String[]{"Options: " + this.options(), "Default: " + String.valueOf(this.getDefaultValue())});
    }

    @Override
    protected List<Component> bonusCommentTooltips() {
        return Lists.newArrayList((Object[])new Component[]{LCText.CONFIG_OPTION_OPTIONS.get(this.options()), LCText.CONFIG_OPTION_DEFAULT.get(((Enum)this.getDefaultValue()).toString())});
    }

    private String options() {
        StringBuilder builder = new StringBuilder();
        for (Enum option : (Enum[])this.clazz.getEnumConstants()) {
            if (!builder.isEmpty()) {
                builder.append(", ");
            }
            builder.append(option.toString());
        }
        return builder.toString();
    }

    public static <T extends Enum<T>> EnumOption<T> create(T defaultValue) {
        return new EnumOption<Enum>(() -> defaultValue, defaultValue.getClass());
    }

    public static <T extends Enum<T>> EnumOption<T> create(Supplier<T> defaultValue, Class<?> clazz) {
        return new EnumOption<T>(defaultValue, clazz);
    }

    private static class EnumParser<T extends Enum<T>>
    implements ConfigParser<T> {
        private final Class<T> clazz;

        private EnumParser(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public T tryParse(String cleanLine) throws ConfigParsingException {
            Enum result = EnumUtil.enumFromString((String)cleanLine, (Enum[])((Enum[])this.clazz.getEnumConstants()), null);
            if (result == null) {
                throw new ConfigParsingException(cleanLine + " is not a valid enum option!");
            }
            return (T)result;
        }

        @Override
        public String write(T value) {
            return ((Enum)value).name();
        }
    }
}

