/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.client.sprites;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FixedSizeSprite;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface FlexibleWidthSprite {
    default public void render(EasyGuiGraphics gui, ScreenPosition position, int width) {
        this.render(gui, position.x, position.y, width);
    }

    public void render(EasyGuiGraphics var1, int var2, int var3, int var4);

    public int getHeight();

    default public boolean canFitInSize(int width) {
        return true;
    }

    default public FixedSizeSprite ofSize(int width) {
        return new FixedSprite(this, width);
    }

    public static class FixedSprite
    implements FixedSizeSprite {
        private final FlexibleWidthSprite sprite;
        private final int width;

        private FixedSprite(FlexibleWidthSprite sprite, int width) {
            this.sprite = sprite;
            this.width = width;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.sprite.getHeight();
        }

        @Override
        public void render(EasyGuiGraphics gui, int x, int y) {
            if (this.sprite.canFitInSize(this.width)) {
                this.sprite.render(gui, x, y, this.width);
            }
        }
    }
}

