/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.coins.data.coin;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.coin.CoinEntry;
import javax.annotation.Nonnull;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;

public class MainCoinEntry
extends CoinEntry {
    private final int exchangeRate;

    @Override
    public final int getExchangeRate() {
        return this.exchangeRate;
    }

    public MainCoinEntry(@Nonnull Item coin, int exchangeRate) {
        super(coin);
        this.exchangeRate = exchangeRate;
    }

    protected MainCoinEntry(@Nonnull Item coin, int exchangeRate, boolean sideChain) {
        super(coin, sideChain);
        this.exchangeRate = exchangeRate;
    }

    @Override
    protected void writeAdditional(@Nonnull JsonObject json) {
        json.addProperty("exchangeRate", (Number)this.exchangeRate);
    }

    public static CoinEntry parseMain(@Nonnull JsonObject json) {
        return MainCoinEntry.parseMain(json, false);
    }

    public static CoinEntry parseMain(@Nonnull JsonObject json, boolean hidden) {
        Item coin = MainCoinEntry.parseBase(json);
        int exchangeRate = GsonHelper.getAsInt((JsonObject)json, (String)"exchangeRate");
        return new MainCoinEntry(coin, exchangeRate, hidden);
    }
}

