/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.notifications;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.ISidedObject;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class Notification
implements ISidedObject {
    private boolean isClient = false;
    private long timeStamp = TimeUtil.getCurrentTime();
    private boolean seen = false;
    private int count = 1;

    @Override
    public final boolean isClient() {
        return this.isClient;
    }

    @Override
    public final boolean isServer() {
        return ISidedObject.super.isServer();
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public final boolean hasTimeStamp() {
        return this.getTimeStamp() > 0L;
    }

    public boolean wasSeen() {
        return this.seen;
    }

    public void setSeen() {
        this.seen = true;
    }

    public int getCount() {
        return this.count;
    }

    protected Notification() {
    }

    protected abstract NotificationType<?> getType();

    public abstract NotificationCategory getCategory();

    public abstract List<Component> getMessageLines();

    public List<Component> getGeneralMessage() {
        return this.getModifiedMessage(line -> LCText.NOTIFICATION_FORMAT_GENERAL.get(this.getCategory().getName(), line));
    }

    public List<Component> getChatMessage() {
        return this.getModifiedMessage(line -> LCText.NOTIFICATION_FORMAT_CHAT.get(LCText.NOTIFICATION_FORMAT_CHAT_TITLE.get(this.getCategory().getName()).withStyle(ChatFormatting.GOLD), line));
    }

    protected final List<Component> getModifiedMessage(UnaryOperator<Component> edit) {
        ArrayList<Component> message = new ArrayList<Component>(this.getMessageLines());
        if (message.isEmpty()) {
            return message;
        }
        message.set(0, (Component)edit.apply((Component)message.getFirst()));
        return message;
    }

    public Component getTimeStampMessage() {
        return LCText.NOTIFICATION_TIMESTAMP.get(TimeUtil.formatTime(this.timeStamp));
    }

    public final CompoundTag save(HolderLookup.Provider lookup) {
        CompoundTag compound = new CompoundTag();
        if (this.seen) {
            compound.putBoolean("Seen", true);
        }
        compound.putInt("Count", this.count);
        compound.putString("Type", this.getType().type.toString());
        if (this.timeStamp > 0L) {
            compound.putLong("TimeStamp", this.timeStamp);
        }
        try {
            this.saveAdditional(compound, lookup);
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error saving Notification of type '" + this.getType().type.toString() + "'", t);
        }
        return compound;
    }

    protected abstract void saveAdditional(CompoundTag var1, HolderLookup.Provider var2);

    public final void load(CompoundTag compound, HolderLookup.Provider lookup) {
        if (compound.contains("Seen")) {
            this.seen = true;
        }
        if (compound.contains("Count", 3)) {
            this.count = compound.getInt("Count");
        }
        this.timeStamp = compound.contains("TimeStamp", 4) ? compound.getLong("TimeStamp") : 0L;
        this.loadAdditional(compound, lookup);
    }

    protected abstract void loadAdditional(CompoundTag var1, HolderLookup.Provider var2);

    public boolean onNewNotification(Notification other) {
        if (this.canMerge(other)) {
            ++this.count;
            this.seen = false;
            this.timeStamp = TimeUtil.getCurrentTime();
            return true;
        }
        return false;
    }

    protected abstract boolean canMerge(Notification var1);

    @Override
    public Notification flagAsClient() {
        return this.flagAsClient(true);
    }

    @Override
    public Notification flagAsClient(boolean isClient) {
        this.isClient = isClient;
        return this;
    }

    @Override
    public Notification flagAsClient(IClientTracker context) {
        return this.flagAsClient(context.isClient());
    }
}

