/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.upgrades;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeData;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.text.MultiLineTextEntry;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class UpgradeType {
    private final List<Component> possibleTargets = new ArrayList<Component>();

    public boolean isUnique() {
        return false;
    }

    @Nonnull
    public List<Component> getTooltip(@Nonnull UpgradeData data) {
        return new ArrayList<Component>();
    }

    @Nonnull
    public List<Component> getTooltipWithContext(@Nonnull UpgradeData data, @Nonnull Item.TooltipContext context) {
        return new ArrayList<Component>();
    }

    public boolean clearDataFromStack(@Nonnull ItemStack stack) {
        return false;
    }

    protected final boolean clearData(@Nonnull ItemStack stack, @Nonnull Supplier<? extends DataComponentType<?>> type) {
        if (stack.has(type)) {
            stack.remove(type);
            return true;
        }
        return false;
    }

    public static boolean hasUpgrade(@Nonnull UpgradeType type, @Nonnull Container upgradeContainer) {
        for (int i = 0; i < upgradeContainer.getContainerSize(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = upgradeContainer.getItem(i);
            Item item = stack.getItem();
            if (!(item instanceof UpgradeItem) || (upgradeItem = (UpgradeItem)item).getUpgradeType() != type) continue;
            return true;
        }
        return false;
    }

    public final void addTarget(@Nonnull Component target) {
        this.possibleTargets.add(target);
    }

    public final void addTarget(@Nonnull ItemLike target) {
        this.addTarget(UpgradeType.formatTarget(target));
    }

    public final void addTarget(@Nonnull Supplier<? extends ItemLike> target) {
        this.addTarget(UpgradeType.formatTarget(target));
    }

    protected static Component formatTarget(@Nonnull ItemLike target) {
        return new ItemStack(target).getHoverName();
    }

    protected static Component formatTarget(@Nonnull Supplier<? extends ItemLike> target) {
        return UpgradeType.formatTarget(target.get());
    }

    @Nonnull
    public final List<Component> getPossibleTargets() {
        ArrayList<Component> temp = new ArrayList<Component>();
        temp.addAll(this.getBuiltInTargets());
        temp.addAll(this.possibleTargets);
        return ImmutableList.copyOf(temp);
    }

    @Nonnull
    protected List<Component> getBuiltInTargets() {
        return new ArrayList<Component>();
    }

    public static class Simple
    extends UpgradeType {
        private final boolean unique;
        private final Supplier<List<Component>> tooltips;
        private final List<Component> targets;
        private final List<OptionalTooltip> optionalTooltips;

        @Override
        public boolean isUnique() {
            return this.unique;
        }

        @Deprecated
        public Simple(Component ... tooltips) {
            this(false, tooltips);
        }

        @Deprecated
        public Simple(boolean unique, Component ... tooltips) {
            this.unique = unique;
            this.tooltips = () -> ImmutableList.copyOf((Object[])tooltips);
            this.targets = new ArrayList<Component>();
            this.optionalTooltips = ImmutableList.of();
        }

        private Simple(@Nonnull Builder builder) {
            this.unique = builder.unique;
            this.tooltips = builder.buildSupplier();
            this.targets = ImmutableList.copyOf(builder.targets);
            this.optionalTooltips = ImmutableList.copyOf(builder.optionalTooltips);
        }

        @Override
        @Nonnull
        public List<Component> getTooltip(@Nonnull UpgradeData data) {
            return this.tooltips.get();
        }

        @Override
        @Nonnull
        public List<Component> getTooltipWithContext(@Nonnull UpgradeData data, @Nonnull Item.TooltipContext context) {
            ArrayList<Component> tooltips = new ArrayList<Component>();
            for (OptionalTooltip ot : this.optionalTooltips) {
                if (!ot.shouldShow.test(context)) continue;
                tooltips.addAll(ot.tooltip);
            }
            return tooltips;
        }

        @Override
        @Nonnull
        protected List<Component> getBuiltInTargets() {
            return this.targets;
        }

        @Deprecated
        public final Simple withTarget(@Nonnull Component target) {
            this.targets.add(target);
            return this;
        }

        @Deprecated
        public final Simple withTarget(@Nonnull ItemLike target) {
            this.targets.add(Simple.formatTarget(target));
            return this;
        }

        @Deprecated
        public final Simple withTarget(@Nonnull Supplier<? extends ItemLike> target) {
            this.targets.add(Simple.formatTarget(target));
            return this;
        }

        @Nonnull
        public static Builder builder() {
            return new Builder();
        }

        @MethodsReturnNonnullByDefault
        @ParametersAreNonnullByDefault
        public static class Builder {
            private final List<Component> tooltips = new ArrayList<Component>();
            private final List<Supplier<List<Component>>> flexibleTooltips = new ArrayList<Supplier<List<Component>>>();
            private final List<OptionalTooltip> optionalTooltips = new ArrayList<OptionalTooltip>();
            private final List<Component> targets = new ArrayList<Component>();
            private boolean unique = false;

            private Builder() {
            }

            private Supplier<List<Component>> buildSupplier() {
                return () -> {
                    ArrayList<Component> list = new ArrayList<Component>(this.tooltips);
                    for (Supplier<List<Component>> supplier : this.flexibleTooltips) {
                        list.addAll((Collection<Component>)supplier.get());
                    }
                    return list;
                };
            }

            public Builder unique() {
                this.unique = true;
                return this;
            }

            public Builder tooltip(Component tooltip) {
                this.tooltips.add(tooltip);
                return this;
            }

            public Builder tooltip(TextEntry entry) {
                this.tooltips.add((Component)entry.get(new Object[0]));
                return this;
            }

            public Builder tooltip(List<Component> tooltips) {
                this.tooltips.addAll(tooltips);
                return this;
            }

            public Builder tooltip(MultiLineTextEntry tooltips) {
                this.flexibleTooltips.add(() -> tooltips.get(new Object[0]));
                return this;
            }

            public Builder tooltip(Supplier<List<Component>> tooltipSource) {
                this.flexibleTooltips.add(tooltipSource);
                return this;
            }

            public Builder target(Component target) {
                this.targets.add(target);
                return this;
            }

            public Builder target(TextEntry target) {
                this.targets.add((Component)target.get(new Object[0]));
                return this;
            }

            public Builder target(ItemLike target) {
                this.targets.add(UpgradeType.formatTarget(target));
                return this;
            }

            public Builder target(Supplier<? extends ItemLike> target) {
                this.targets.add(UpgradeType.formatTarget(target));
                return this;
            }

            public Builder optionalTooltip(Predicate<Item.TooltipContext> shouldDisplay, Component tooltip) {
                return this.optionalTooltip(shouldDisplay, (List<Component>)ImmutableList.of((Object)tooltip));
            }

            public Builder optionalTooltip(Predicate<Item.TooltipContext> shouldDisplay, TextEntry tooltip) {
                return this.optionalTooltip(shouldDisplay, (List<Component>)ImmutableList.of((Object)tooltip.get(new Object[0])));
            }

            public Builder optionalTooltip(Predicate<Item.TooltipContext> shouldDisplay, List<Component> tooltip) {
                this.optionalTooltips.add(new OptionalTooltip(shouldDisplay, tooltip));
                return this;
            }

            public Builder optionalTooltip(Supplier<Boolean> shouldDisplay, Component tooltip) {
                return this.optionalTooltip(shouldDisplay, (List<Component>)ImmutableList.of((Object)tooltip));
            }

            public Builder optionalTooltip(Supplier<Boolean> shouldDisplay, TextEntry tooltip) {
                return this.optionalTooltip(shouldDisplay, (List<Component>)ImmutableList.of((Object)tooltip.get(new Object[0])));
            }

            public Builder optionalTooltip(Supplier<Boolean> shouldDisplay, List<Component> tooltip) {
                this.optionalTooltips.add(new OptionalTooltip(c -> (Boolean)shouldDisplay.get(), tooltip));
                return this;
            }

            public Simple build() {
                return new Simple(this);
            }
        }

        private record OptionalTooltip(@Nonnull Predicate<Item.TooltipContext> shouldShow, @Nonnull List<Component> tooltip) {
        }
    }
}

