/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyValueWidget;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeInputWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.auction.AuctionCreateTab;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import io.github.lightman314.lightmanscurrency.network.message.persistentdata.CPacketCreatePersistentAuction;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AuctionCreateClientTab
extends TraderStorageClientTab<AuctionCreateTab> {
    public static final long CLOSE_DELAY = 5000L;
    AuctionTradeData pendingAuction;
    TradeButton tradeDisplay;
    MoneyValueWidget priceSelect;
    EasyButton buttonTogglePriceMode;
    boolean startingBidMode = true;
    EasyButton buttonToggleOvertime;
    ScreenArea overtimeTextArea;
    EasyButton buttonSubmitAuction;
    boolean locked = false;
    long successTime = 0L;
    EasyButton buttonSubmitPersistentAuction;
    EditBox persistentAuctionIDInput;
    TimeInputWidget timeInput;

    public AuctionCreateClientTab(Object screen, AuctionCreateTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_PLUS;
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_TRADER_AUCTION_CREATE.get(new Object[0]);
    }

    @Override
    public boolean blockInventoryClosing() {
        return LCAdminMode.isAdminPlayer(((ITraderStorageScreen)this.screen).getMenu().getPlayer());
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        if (firstOpen) {
            this.pendingAuction = new AuctionTradeData(((ITraderStorageMenu)this.menu).getPlayer());
            this.locked = false;
            this.successTime = 0L;
            this.startingBidMode = true;
            ((AuctionCreateTab)this.commonTab).getAuctionItems().addListener(c -> this.UpdateAuctionItems());
        }
        this.tradeDisplay = this.addChild(((TradeButton.Builder)TradeButton.builder().position(screenArea.pos.offset(15, 5))).context(((ITraderStorageMenu)this.menu)::getContext).trade(this.pendingAuction).build());
        this.priceSelect = this.addChild(((MoneyValueWidget.Builder)MoneyValueWidget.builder().position(screenArea.pos.offset(screenArea.width / 2 - 88, 34))).oldIfNotFirst(firstOpen, this.priceSelect).valueHandler(this::onPriceChanged).blockFreeInputs().allowHandlerChange(() -> this.startingBidMode).build());
        this.buttonTogglePriceMode = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(114, 4))).width(screenArea.width - 119)).text(this::getBidModeText).pressAction(this::TogglePriceTarget)).addon(EasyAddonHelper.activeCheck(this::isUnlocked))).build());
        this.buttonToggleOvertime = this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(15, 26))).pressAction(this::ToggleOvertime)).sprite(SpriteUtil.createCheckbox(() -> this.pendingAuction.isOvertimeAllowed())).addon(EasyAddonHelper.activeCheck(this::isUnlocked))).build());
        this.overtimeTextArea = ScreenArea.of(26, 27, this.getFont().width((FormattedText)LCText.GUI_TRADER_AUCTION_OVERTIME.get(new Object[0])), 10);
        long minDuration = Math.max((long)((Integer)LCConfig.SERVER.auctionHouseDurationMin.get()).intValue() * 86400000L, 3600000L);
        this.timeInput = this.addChild(((TimeInputWidget.Builder)((TimeInputWidget.Builder)TimeInputWidget.builder().position(screenArea.pos.offset(80, 112))).unitRange(TimeUtil.TimeUnit.HOUR, TimeUtil.TimeUnit.DAY).handler(this::updateDuration).minDuration(minDuration).maxDuration((long)Math.max((Integer)LCConfig.SERVER.auctionHouseDurationMax.get(), (Integer)LCConfig.SERVER.auctionHouseDurationMin.get()) * 86400000L).startTime(AuctionTradeData.GetDefaultDuration()).addon(EasyAddonHelper.activeCheck(this::isUnlocked))).build());
        this.buttonSubmitAuction = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width - 41, 120))).icon(IconUtil.ICON_PLUS).pressAction(this::submitAuction)).addon(EasyAddonHelper.activeCheck(this::canSubmit))).addon(EasyAddonHelper.tooltips(this::getSubmitButtonTooltips, 256, true))).build());
        this.buttonSubmitAuction.active = false;
        this.buttonSubmitPersistentAuction = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width - 20, -20))).pressAction(this::submitPersistentAuction)).icon(IconUtil.ICON_PERSISTENT_DATA).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_PERSISTENT_CREATE_AUCTION))).addon(EasyAddonHelper.visibleCheck(this::isAdminMode))).build());
        this.buttonSubmitPersistentAuction.active = false;
        int idWidth = this.getFont().width((FormattedText)LCText.GUI_PERSISTENT_ID.get(new Object[0]));
        this.persistentAuctionIDInput = this.addChild(new EditBox(this.getFont(), screenArea.x + idWidth + 2, screenArea.y - 20, screenArea.width - idWidth - 2, 18, (Component)EasyText.empty()));
        this.persistentAuctionIDInput.visible = LCAdminMode.isAdminPlayer(((ITraderStorageScreen)this.screen).getPlayer());
    }

    @Override
    public void closeAction() {
        ((AuctionCreateTab)this.commonTab).getAuctionItems().removeListener(c -> this.UpdateAuctionItems());
    }

    @Override
    public void renderBG(EasyGuiGraphics gui) {
        gui.resetColor();
        for (EasySlot slot : ((AuctionCreateTab)this.commonTab).getSlots()) {
            gui.renderSlot((IEasyScreen)this.screen, slot);
        }
        gui.drawString((Component)LCText.GUI_TRADER_AUCTION_ITEMS.get(new Object[0]), 22, 112, 0x404040);
        gui.drawString((Component)LCText.GUI_TRADER_AUCTION_OVERTIME.get(new Object[0]), this.overtimeTextArea.pos, 0x404040);
        if (this.locked && this.successTime != 0L) {
            TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_TRADER_AUCTION_CREATE_SUCCESS.getWithStyle(ChatFormatting.BOLD), ((ITraderStorageScreen)this.screen).getXSize() / 2, 34, 0x404040);
        }
        if (LCAdminMode.isAdminPlayer(((ITraderStorageScreen)this.screen).getPlayer())) {
            gui.drawString((Component)LCText.GUI_PERSISTENT_ID.get(new Object[0]), 0, -15, 0xFFFFFF);
        }
    }

    @Override
    public void renderAfterWidgets(EasyGuiGraphics gui) {
        if (this.overtimeTextArea.offsetPosition(((ITraderStorageScreen)this.screen).getCorner()).isMouseInArea(gui.mousePos)) {
            gui.renderComponentTooltip(TooltipHelper.splitTooltips(LCText.TOOLTIP_TRADER_AUCTION_OVERTIME.get(new Object[0]), new ChatFormatting[0]));
        }
    }

    private boolean isUnlocked() {
        return !this.locked;
    }

    private boolean canSubmit() {
        if (this.isUnlocked() && this.pendingAuction.isValid()) {
            if (LCAdminMode.isAdminPlayer(((ITraderStorageMenu)this.menu).getPlayer())) {
                return true;
            }
            TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
            if (traderData instanceof AuctionHouseTrader) {
                IMoneyHolder handler;
                AuctionHouseTrader ah = (AuctionHouseTrader)traderData;
                if (LCAdminMode.isAdminPlayer(((ITraderStorageMenu)this.menu).getPlayer())) {
                    return true;
                }
                MoneyValue price = (MoneyValue)LCConfig.SERVER.auctionHouseSubmitPrice.get();
                if (!price.isEmpty() && !(handler = MoneyAPI.getApi().GetPlayersMoneyHandler(((ITraderStorageMenu)this.menu).getPlayer())).extractMoney(price, true).isEmpty()) {
                    return false;
                }
                int count = ah.getPlayerTradeCount(((ITraderStorageMenu)this.menu).getPlayer());
                return count < (Integer)LCConfig.SERVER.auctionHousePlayerLimit.get();
            }
        }
        return false;
    }

    private boolean isAdminMode() {
        return LCAdminMode.isAdminPlayer(((ITraderStorageMenu)this.menu).getPlayer());
    }

    private List<Component> getSubmitButtonTooltips() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof AuctionHouseTrader) {
            int limit;
            int count;
            int feePercent;
            MoneyValue price;
            AuctionHouseTrader ah = (AuctionHouseTrader)traderData;
            if (this.canSubmit()) {
                tooltip.add((Component)LCText.BUTTON_TRADER_AUCTION_CREATE.getWithStyle(ChatFormatting.BOLD));
            }
            if (!(price = (MoneyValue)LCConfig.SERVER.auctionHouseSubmitPrice.get()).isEmpty()) {
                tooltip.add((Component)LCText.TOOLTIP_TRADER_AUCTION_PRICE.get(price.getText()));
            }
            if ((feePercent = ((Integer)LCConfig.SERVER.auctionHouseFeePercentage.get()).intValue()) > 0) {
                tooltip.add((Component)LCText.TOOLTIP_TRADER_AUCTION_FEE_WARNING.get(feePercent));
            }
            if (!LCAdminMode.isAdminPlayer(((ITraderStorageMenu)this.menu).getPlayer()) && (count = ah.getPlayerTradeCount(((ITraderStorageMenu)this.menu).getPlayer())) >= (limit = ((Integer)LCConfig.SERVER.auctionHousePlayerLimit.get()).intValue())) {
                tooltip.addAll(LCText.TOOLTIP_TRADER_AUCTION_LIMIT_EXCEEDED.get(limit, count));
            }
        }
        return tooltip;
    }

    @Override
    public void tick() {
        if (this.locked && !this.priceSelect.isLocked()) {
            this.priceSelect.lock();
        }
        if (this.locked && this.successTime != 0L && TimeUtil.compareTime(5000L, this.successTime)) {
            ((ITraderStorageScreen)this.screen).ChangeTab(0);
            return;
        }
        if (LCAdminMode.isAdminPlayer(((ITraderStorageScreen)this.screen).getPlayer())) {
            this.persistentAuctionIDInput.visible = !this.locked;
            this.buttonSubmitPersistentAuction.visible = this.persistentAuctionIDInput.visible;
            this.buttonSubmitPersistentAuction.active = this.pendingAuction.isValid();
        } else {
            this.persistentAuctionIDInput.visible = false;
            this.buttonSubmitPersistentAuction.visible = false;
        }
    }

    private void UpdateAuctionItems() {
        this.pendingAuction.setAuctionItems((Container)((AuctionCreateTab)this.commonTab).getAuctionItems());
    }

    private void onPriceChanged(MoneyValue newPrice) {
        if (this.startingBidMode) {
            this.pendingAuction.setStartingBid(newPrice);
        } else {
            this.pendingAuction.setMinBidDifferent(newPrice);
        }
    }

    private void TogglePriceTarget() {
        boolean bl = this.startingBidMode = !this.startingBidMode;
        if (this.startingBidMode) {
            this.priceSelect.changeValue(this.pendingAuction.getLastBidAmount());
        } else {
            this.priceSelect.changeValue(this.pendingAuction.getMinBidDifference());
        }
    }

    private void ToggleOvertime(EasyButton button) {
        this.pendingAuction.setOvertimeAllowed(!this.pendingAuction.isOvertimeAllowed());
    }

    private Component getBidModeText() {
        return this.startingBidMode ? LCText.BUTTON_TRADER_AUCTION_PRICE_MODE_STARTING_BID.get(new Object[0]) : LCText.BUTTON_TRADER_AUCTION_PRICE_MODE_MIN_BID_SIZE.get(new Object[0]);
    }

    private void updateDuration(TimeUtil.TimeData newTime) {
        this.pendingAuction.setDuration(newTime.miliseconds);
    }

    private void submitAuction() {
        ((AuctionCreateTab)this.commonTab).createAuction(this.pendingAuction);
        this.locked = true;
        for (EasySlot slot : ((AuctionCreateTab)this.commonTab).getSlots()) {
            slot.locked = true;
        }
    }

    private void submitPersistentAuction(EasyButton button) {
        new CPacketCreatePersistentAuction(this.pendingAuction.getAsNBT((HolderLookup.Provider)this.registryAccess()), this.persistentAuctionIDInput.getValue()).send();
    }

    @Override
    public void receiveServerMessage(LazyPacketData message) {
        if (message.contains("AuctionCreated")) {
            if (message.getBoolean("AuctionCreated")) {
                this.successTime = TimeUtil.getCurrentTime();
            } else {
                this.locked = false;
                for (EasySlot slot : ((AuctionCreateTab)this.commonTab).getSlots()) {
                    slot.locked = false;
                }
            }
        }
    }
}

