/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.command;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IKeyboardListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.mixin.client.CommandSuggestionsAccessor;
import io.github.lightman314.lightmanscurrency.mixin.client.SuggestionsListAccessor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CommandEditField
extends EasyWidgetWithChildren
implements IKeyboardListener,
IMouseListener,
IScrollListener {
    private final CommandEditField oldWidget;
    private final Consumer<String> handler;
    private final int suggestionCount;
    private final Supplier<Boolean> showSuggestions;
    private final String startingValue;
    private EditBox textbox;
    private CommandSuggestions commandSuggestions;

    protected CommandEditField(Builder builder) {
        super(builder);
        this.oldWidget = builder.oldWidget;
        this.handler = builder.handler;
        this.suggestionCount = builder.suggestionCount;
        this.showSuggestions = builder.showSuggestions;
        this.startingValue = builder.startingValue;
    }

    @Override
    protected void renderTick() {
        if (this.textbox != null) {
            this.textbox.visible = this.visible;
        }
    }

    @Override
    public void addChildren(ScreenArea area) {
        this.textbox = this.addChild(new EditBox(this.getFont(), this.getX(), this.getY(), this.width, this.height, (Component)EasyText.empty()));
        this.textbox.setMaxLength(32500);
        this.textbox.setValue(this.startingValue);
        this.textbox.setResponder(this::onCommandChanged);
        this.textbox.visible = this.visible;
        this.commandSuggestions = new CommandSuggestions(Minecraft.getInstance(), Minecraft.getInstance().screen, this.textbox, this.getFont(), true, true, 0, this.suggestionCount, false, Integer.MIN_VALUE);
        this.commandSuggestions.setAllowSuggestions(true);
        this.commandSuggestions.updateCommandInfo();
        if (this.oldWidget != null && this.oldWidget.textbox != null) {
            this.textbox.setValue(this.oldWidget.textbox.getValue());
        }
    }

    @Override
    protected void renderWidget(EasyGuiGraphics gui) {
        CommandSuggestions commandSuggestions;
        if (!this.showSuggestions.get().booleanValue()) {
            return;
        }
        this.repositionSuggestions();
        if (!this.commandSuggestions.renderSuggestions(gui.getGui(), gui.mousePos.x, gui.mousePos.y) && (commandSuggestions = this.commandSuggestions) instanceof CommandSuggestionsAccessor) {
            CommandSuggestionsAccessor sa = (CommandSuggestionsAccessor)commandSuggestions;
            int i = 0;
            int fillColor = sa.getFillColor();
            for (FormattedCharSequence formattedcharsequence : sa.getCommandUsage()) {
                Font font = gui.font;
                if (formattedcharsequence instanceof FormattedText) {
                    FormattedText text = (FormattedText)formattedcharsequence;
                    for (FormattedCharSequence line : font.split(text, this.width)) {
                        int j = 18 + 12 * i;
                        gui.fill(0, j, this.width, 12, fillColor);
                        gui.drawShadowed(line, 0, j + 2, -1);
                        ++i;
                    }
                    continue;
                }
                int j = 18 + 12 * i;
                gui.fill(0, j, this.width, 12, fillColor);
                gui.drawShadowed(formattedcharsequence, 0, j + 2, -1);
                ++i;
            }
        }
    }

    public void setCommand(String newCommand) {
        if (this.textbox != null) {
            this.textbox.setValue(newCommand);
        }
    }

    private void onCommandChanged(String newCommand) {
        this.commandSuggestions.updateCommandInfo();
        this.handler.accept(newCommand);
    }

    @Override
    public boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        if (!this.showSuggestions.get().booleanValue()) {
            return false;
        }
        return this.commandSuggestions.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.showSuggestions.get().booleanValue()) {
            return false;
        }
        this.repositionSuggestions();
        if (!this.commandSuggestions.mouseClicked(mouseX, mouseY, button)) {
            if (!this.textbox.mouseClicked(mouseX, mouseY, button)) {
                this.textbox.setFocused(false);
            }
            return false;
        }
        return true;
    }

    private void repositionSuggestions() {
        CommandSuggestionsAccessor sa;
        CommandSuggestions.SuggestionsList suggestions;
        CommandSuggestions commandSuggestions = this.commandSuggestions;
        if (commandSuggestions instanceof CommandSuggestionsAccessor && (suggestions = (sa = (CommandSuggestionsAccessor)commandSuggestions).getSuggestions()) instanceof SuggestionsListAccessor) {
            SuggestionsListAccessor sla = (SuggestionsListAccessor)suggestions;
            Rect2i rect = sla.getRect();
            sla.setRect(new Rect2i(rect.getX(), this.getY() + 18, rect.getWidth(), rect.getHeight()));
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (!this.showSuggestions.get().booleanValue()) {
            return false;
        }
        return this.commandSuggestions.mouseScrolled(delta);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends EasyWidget.EasySizableBuilder<Builder> {
        @Nullable
        private CommandEditField oldWidget = null;
        private Consumer<String> handler = s -> {};
        private int suggestionCount = 5;
        private Supplier<Boolean> showSuggestions = () -> true;
        private String startingValue = "";

        private Builder() {
            super(100, 18);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder oldIfNotFirst(boolean firstOpen, @Nullable CommandEditField oldWidget) {
            if (!firstOpen) {
                this.oldWidget = oldWidget;
            }
            return this;
        }

        public Builder handler(Consumer<String> handler) {
            this.handler = handler;
            return this;
        }

        public Builder suggestions(int suggestionCount) {
            this.suggestionCount = suggestionCount;
            return this;
        }

        public Builder showSuggestions(Supplier<Boolean> showSuggestions) {
            this.showSuggestions = showSuggestions;
            return this;
        }

        public Builder startingValue(String startingValue) {
            this.startingValue = startingValue;
            return this;
        }

        public CommandEditField build() {
            return new CommandEditField(this);
        }
    }
}

