/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.renderers;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.BookRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.BookRendererGenerator;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.SimpleBookRenderer;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class NormalBookRenderer
extends SimpleBookRenderer {
    public static final ModelResourceLocation MODEL_LOCATION = NormalBookRenderer.modelLocation(VersionUtil.lcResource("block/bookshelf_trader/books/book"));
    public static final NormalBookRenderer INSTANCE = new NormalBookRenderer(new ItemStack((ItemLike)Items.BOOK));
    public static final BookRendererGenerator GENERATOR = new Generator();

    private NormalBookRenderer(ItemStack book) {
        super(book);
    }

    @Override
    protected ModelResourceLocation getBookModel() {
        return MODEL_LOCATION;
    }

    private static class Generator
    implements BookRendererGenerator {
        private final List<Item> bookItems = ImmutableList.of((Object)Items.BOOK, (Object)Items.WRITABLE_BOOK, (Object)Items.WRITTEN_BOOK);

        private Generator() {
        }

        @Override
        @Nullable
        public BookRenderer createRendererForItem(@Nonnull ItemStack book) {
            if (this.bookItems.contains(book.getItem())) {
                return INSTANCE;
            }
            return null;
        }
    }
}

