/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class TextRenderUtil {
    public static Font getFont() {
        Minecraft mc = Minecraft.getInstance();
        return mc.font;
    }

    public static Component fitString(String text, int width) {
        return TextRenderUtil.fitString(text, width, "...");
    }

    public static Component fitString(String text, int width, Style style) {
        return TextRenderUtil.fitString(text, width, "...", style);
    }

    public static Component fitString(String text, int width, String edge) {
        return TextRenderUtil.fitString((Component)Component.literal((String)text), width, edge);
    }

    public static Component fitString(Component component, int width) {
        return TextRenderUtil.fitString(component.getString(), width, "...", component.getStyle());
    }

    public static Component fitString(Component component, int width, String edge) {
        return TextRenderUtil.fitString(component.getString(), width, edge, component.getStyle());
    }

    public static Component fitString(Component component, int width, Style style) {
        return TextRenderUtil.fitString(component.getString(), width, "...", style);
    }

    public static Component fitString(Component component, int width, String edge, Style style) {
        return TextRenderUtil.fitString(component.getString(), width, edge, style);
    }

    public static Component fitString(String text, int width, String edge, Style style) {
        Font font = TextRenderUtil.getFont();
        if (font.width((FormattedText)Component.literal((String)text).withStyle(style)) <= width) {
            return Component.literal((String)text).withStyle(style);
        }
        while (font.width((FormattedText)Component.literal((String)(text + edge)).withStyle(style)) > width && !text.isEmpty()) {
            text = text.substring(0, text.length() - 1);
        }
        if (text.charAt(text.length() - 1) == ' ') {
            text = text.substring(0, text.length() - 1);
        }
        return Component.literal((String)(text + edge)).withStyle(style);
    }

    public static void drawCenteredText(EasyGuiGraphics gui, String string, int centerX, int yPos, int color) {
        TextRenderUtil.drawCenteredText(gui, string, centerX, yPos, color, false);
    }

    public static void drawCenteredText(EasyGuiGraphics gui, Component component, int centerX, int yPos, int color) {
        TextRenderUtil.drawCenteredText(gui, component, centerX, yPos, color, false);
    }

    public static void drawCenteredText(EasyGuiGraphics gui, String string, int centerX, int yPos, int color, boolean shadowed) {
        TextRenderUtil.drawCenteredText(gui, (Component)Component.literal((String)string), centerX, yPos, color, shadowed);
    }

    public static void drawCenteredText(EasyGuiGraphics gui, Component component, int centerX, int yPos, int color, boolean shadowed) {
        int width = gui.font.width((FormattedText)component);
        if (shadowed) {
            gui.drawShadowed(component, centerX - width / 2, yPos, color);
        } else {
            gui.drawString(component, centerX - width / 2, yPos, color);
        }
    }

    public static void drawRightEdgeText(EasyGuiGraphics gui, String string, int rightPos, int yPos, int color) {
        TextRenderUtil.drawRightEdgeText(gui, (Component)Component.literal((String)string), rightPos, yPos, color);
    }

    public static void drawRightEdgeText(EasyGuiGraphics gui, Component component, int rightPos, int yPos, int color) {
        int width = gui.font.width((FormattedText)component);
        gui.drawString(component, rightPos - width, yPos, color);
    }

    public static void drawCenteredMultilineText(EasyGuiGraphics gui, String string, int leftPos, int width, int topPos, int color) {
        TextRenderUtil.drawCenteredMultilineText(gui, (Component)Component.literal((String)string), leftPos, width, topPos, color);
    }

    public static void drawCenteredMultilineText(EasyGuiGraphics gui, String string, int leftPos, int width, int topPos, int color, boolean shadowed) {
        TextRenderUtil.drawCenteredMultilineText(gui, (Component)Component.literal((String)string), leftPos, width, topPos, color, shadowed);
    }

    public static void drawCenteredMultilineText(EasyGuiGraphics gui, Component component, int leftPos, int width, int topPos, int color) {
        TextRenderUtil.drawCenteredMultilineText(gui, component, leftPos, width, topPos, color, false);
    }

    public static void drawCenteredMultilineText(EasyGuiGraphics gui, Component component, int leftPos, int width, int topPos, int color, boolean shadowed) {
        Font font = TextRenderUtil.getFont();
        List lines = font.split((FormattedText)component, width);
        float centerPos = (float)leftPos + (float)width / 2.0f;
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            int lineWidth = font.width(line);
            if (shadowed) {
                int n = (int)(centerPos - (float)lineWidth / 2.0f);
                Objects.requireNonNull(font);
                gui.drawShadowed(line, n, topPos + 9 * i, color);
                continue;
            }
            int n = (int)(centerPos - (float)lineWidth / 2.0f);
            Objects.requireNonNull(font);
            gui.drawString(line, n, topPos + 9 * i, color);
        }
    }

    public static void drawVerticallyCenteredMultilineText(EasyGuiGraphics gui, String string, int leftPos, int width, int topPos, int height, int color) {
        TextRenderUtil.drawVerticallyCenteredMultilineText(gui, (Component)Component.literal((String)string), leftPos, width, topPos, height, color);
    }

    public static void drawVerticallyCenteredMultilineText(EasyGuiGraphics gui, Component component, int leftPos, int width, int topPos, int height, int color) {
        Font font = TextRenderUtil.getFont();
        List lines = font.split((FormattedText)component, width);
        float centerPos = (float)leftPos + (float)width / 2.0f;
        float f = (float)topPos + (float)height / 2.0f;
        Objects.requireNonNull(font);
        float startHeight = f - (float)(9 * lines.size()) / 2.0f;
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            int lineWidth = font.width(line);
            int n = (int)(centerPos - (float)lineWidth / 2.0f);
            Objects.requireNonNull(font);
            gui.drawString(line, n, (int)(startHeight + (float)(9 * i)), color);
        }
    }

    public static MutableComponent changeStyle(Component component, UnaryOperator<Style> styleChanges) {
        if (component instanceof MutableComponent) {
            MutableComponent mc = (MutableComponent)component;
            return mc.withStyle(styleChanges);
        }
        return Component.empty().append(component).withStyle(component.getStyle()).withStyle(styleChanges);
    }

    public static class TextFormatting {
        private Centering centering = Centering.MIDDLE_CENTER;
        private int color = 0xFFFFFF;

        public Centering centering() {
            return this.centering;
        }

        public int color() {
            return this.color;
        }

        private TextFormatting() {
        }

        public static TextFormatting create() {
            return new TextFormatting();
        }

        public TextFormatting topEdge() {
            this.centering = this.centering.makeTop();
            return this;
        }

        public TextFormatting middle() {
            this.centering = this.centering.makeMiddle();
            return this;
        }

        public TextFormatting bottomEdge() {
            this.centering = this.centering.makeBottom();
            return this;
        }

        public TextFormatting leftEdge() {
            this.centering = this.centering.makeLeft();
            return this;
        }

        public TextFormatting centered() {
            this.centering = this.centering.makeCenter();
            return this;
        }

        public TextFormatting rightEdge() {
            this.centering = this.centering.makeRight();
            return this;
        }

        public TextFormatting color(int color) {
            this.color = color;
            return this;
        }

        public static enum Centering {
            TOP_LEFT(-1, 1),
            TOP_CENTER(0, 1),
            TOP_RIGHT(1, 1),
            MIDDLE_LEFT(-1, 0),
            MIDDLE_CENTER(0, 0),
            MIDDLE_RIGHT(1, 0),
            BOTTOM_LEFT(-1, -1),
            BOTTOM_CENTER(0, -1),
            BOTTOM_RIGHT(1, -1);

            private final int horiz;
            private final int vert;

            private Centering(int horiz, int vert) {
                this.horiz = horiz;
                this.vert = vert;
            }

            public boolean isTop() {
                return this.vert > 0;
            }

            public boolean isMiddle() {
                return this.vert == 0;
            }

            public boolean isBottom() {
                return this.vert < 0;
            }

            public boolean isLeft() {
                return this.horiz < 0;
            }

            public boolean isCenter() {
                return this.horiz == 0;
            }

            public boolean isRight() {
                return this.horiz > 1;
            }

            public Centering makeTop() {
                return this.of(this.horiz, 1);
            }

            public Centering makeMiddle() {
                return this.of(this.horiz, 0);
            }

            public Centering makeBottom() {
                return this.of(this.horiz, -1);
            }

            public Centering makeLeft() {
                return this.of(-1, this.vert);
            }

            public Centering makeCenter() {
                return this.of(0, this.vert);
            }

            public Centering makeRight() {
                return this.of(1, this.vert);
            }

            private Centering of(int horiz, int vert) {
                for (Centering c : Centering.values()) {
                    if (c.horiz != horiz || c.vert != vert) continue;
                    return c;
                }
                return this;
            }
        }
    }
}

