/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.traderblocks;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.TraderBlockRotatable;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.GachaMachineBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.variant.IVariantBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GachaMachineBlock
extends TraderBlockRotatable
implements IVariantBlock {
    public static final List<ResourceLocation> BASIC_MODELS = ImmutableList.of((Object)VersionUtil.lcResource("block/gacha_machine/basic_1"), (Object)VersionUtil.lcResource("block/gacha_machine/basic_2"), (Object)VersionUtil.lcResource("block/gacha_machine/basic_3"));
    protected final int color;

    public int getColor() {
        return this.color;
    }

    public GachaMachineBlock(BlockBehaviour.Properties properties, Color color) {
        this(properties, color.hexColor);
    }

    public GachaMachineBlock(BlockBehaviour.Properties properties, int color) {
        super(properties, GachaMachineBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
        this.color = color;
    }

    public List<ResourceLocation> getBasicModels() {
        return BASIC_MODELS;
    }

    @Override
    protected BlockEntity makeTrader(BlockPos pos, BlockState state) {
        return new GachaMachineBlockEntity(pos, state, this.color);
    }

    @Override
    protected BlockEntityType<?> traderType() {
        return ModBlockEntities.GACHA_MACHINE.get();
    }

    @Override
    protected Supplier<List<Component>> getItemTooltips() {
        return LCText.TOOLTIP_GACHA_MACHINE.asTooltip(new Object[0]);
    }
}

