/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.input.TicketStationRecipeInput;
import io.github.lightman314.lightmanscurrency.common.data.types.TicketDataCache;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.menus.slots.ticket.TicketModifierSlot;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.Tags;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MasterTicketRecipe
implements TicketStationRecipe {
    public static final MapCodec<MasterTicketRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(r -> r.ingredient), (App)ResourceLocation.CODEC.fieldOf("result").forGetter(MasterTicketRecipe::resultID)).apply((Applicative)builder, MasterTicketRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MasterTicketRecipe> STREAM_CODEC = StreamCodec.of(MasterTicketRecipe::toNetwork, MasterTicketRecipe::fromNetwork);
    private final Ingredient ingredient;
    private final Item result;

    private ResourceLocation resultID() {
        return BuiltInRegistries.ITEM.getKey((Object)this.result);
    }

    private MasterTicketRecipe(Ingredient ingredient, ResourceLocation resultID) {
        this(ingredient, (Item)BuiltInRegistries.ITEM.get(resultID));
    }

    public MasterTicketRecipe(Ingredient ingredient, Item result) {
        this.ingredient = ingredient;
        this.result = result;
    }

    @Override
    public boolean consumeModifier() {
        return true;
    }

    @Override
    public List<ItemStack> jeiModifierList() {
        return TicketStationRecipe.exampleModifierList((TagKey<Item>)Tags.Items.DYES, Items.AIR);
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public ItemStack exampleResult() {
        return TicketItem.CreateTicket(this.result, -1L, 0xFFFF00);
    }

    @Override
    public boolean validModifier(ItemStack stack) {
        return stack.isEmpty() || stack.is(Tags.Items.DYES);
    }

    @Override
    public boolean validIngredient(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public ItemStack assemble(TicketStationRecipeInput container, HolderLookup.Provider lookup) {
        long nextTicketID = TicketDataCache.TYPE.isLoaded(false) ? TicketDataCache.TYPE.get(false).createNextID() : -100L;
        ItemStack dyeStack = container.getItem(0);
        Color dyeColor = TicketModifierSlot.getColorFromDye(dyeStack);
        int color = dyeColor == null ? TicketItem.GetDefaultTicketColor(nextTicketID) : dyeColor.hexColor;
        return TicketItem.CreateTicket(this.result, nextTicketID, color, 1);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider lookup) {
        long nextTicketID = TicketDataCache.TYPE.getUnknown().peekNextID();
        int color = TicketItem.GetDefaultTicketColor(nextTicketID);
        return TicketItem.CreateTicket(this.result, nextTicketID, color, 1);
    }

    @Override
    public ItemStack peekAtResult(Container container, TicketStationRecipe.ExtraData data) {
        long nextTicketID = TicketDataCache.TYPE.getUnknown().peekNextID();
        ItemStack dyeStack = container.getItem(0);
        Color dyeColor = TicketModifierSlot.getColorFromDye(dyeStack);
        if (dyeColor != null) {
            return TicketItem.CreateTicket(this.result, nextTicketID, dyeColor.hexColor);
        }
        return TicketItem.CreateTicket(this.result, nextTicketID);
    }

    @Override
    public ItemStack assembleWithKiosk(ItemStack sellItem, TicketStationRecipe.ExtraData data) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.TICKET_MASTER.get();
    }

    private static MasterTicketRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        return new MasterTicketRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer));
    }

    private static void toNetwork(RegistryFriendlyByteBuf buffer, MasterTicketRecipe recipe) {
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
        ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.resultID());
    }

    public static class Serializer
    implements RecipeSerializer<MasterTicketRecipe> {
        public MapCodec<MasterTicketRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MasterTicketRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

