/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items.cards;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.QuarantineAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.items.data.ATMCardData;
import io.github.lightman314.lightmanscurrency.common.menus.ATMCardMenu;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ATMCardItem
extends Item {
    public ATMCardItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        ATMCardData data = (ATMCardData)stack.getOrDefault(ModDataComponents.ATM_CARD_DATA, (Object)ATMCardData.EMPTY);
        if (data.bankReference().isEmpty()) {
            tooltip.add((Component)LCText.TOOLTIP_ATM_CARD_NOT_LINKED.getWithStyle(ChatFormatting.GRAY));
        } else {
            BankReference reference = data.getBankReference(true);
            IBankAccount account = reference.get();
            if (account == null) {
                tooltip.add((Component)LCText.TOOLTIP_ATM_CARD_NOT_LINKED.getWithStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)LCText.TOOLTIP_ATM_CARD_ACCOUNT.get(account.getName().withStyle(ChatFormatting.YELLOW)).withStyle(ChatFormatting.GRAY));
                if (!account.isCardValid(data.validation())) {
                    tooltip.add((Component)LCText.TOOLTIP_ATM_CARD_LINK_INVALID.getWithStyle(ChatFormatting.RED));
                } else {
                    tooltip.add((Component)account.getBalanceText().withStyle(ChatFormatting.GRAY));
                    tooltip.addAll(TooltipHelper.splitTooltips((Component)LCText.TOOLTIP_PAYMENT_CARD_USAGE.get(new Object[0]), ChatFormatting.GRAY));
                }
            }
        }
        if (data.locked()) {
            tooltip.add((Component)LCText.TOOLTIP_ATM_CARD_ACCOUNT_LOCKED.getWithStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public void verifyComponentsAfterLoad(@Nonnull ItemStack stack) {
        if (!stack.has(ModDataComponents.ATM_CARD_DATA)) {
            stack.set(ModDataComponents.ATM_CARD_DATA, (Object)ATMCardData.EMPTY);
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack card = player.getItemInHand(hand);
        if (!level.isClientSide) {
            if (QuarantineAPI.IsDimensionQuarantined(level)) {
                EasyText.sendMessage(player, (Component)LCText.MESSAGE_DIMENSION_QUARANTINED_BANK.getWithStyle(ChatFormatting.GOLD));
                return InteractionResultHolder.success((Object)card);
            }
            int inventorySlot = -1;
            for (int i = 0; i < player.getInventory().getContainerSize() && inventorySlot < 0; ++i) {
                ItemStack stack = player.getInventory().getItem(i);
                if (stack != card) continue;
                inventorySlot = i;
            }
            if (inventorySlot >= 0) {
                int slot = inventorySlot;
                ATMCardData data = (ATMCardData)card.getOrDefault(ModDataComponents.ATM_CARD_DATA, (Object)ATMCardData.EMPTY);
                if (data.locked() && !LCAdminMode.isAdminPlayer(player)) {
                    player.sendSystemMessage((Component)LCText.MESSAGE_ATM_CARD_LOCKED.get(new Object[0]));
                    return new InteractionResultHolder(InteractionResult.SUCCESS_NO_ITEM_USED, (Object)card);
                }
                player.openMenu(ATMCardMenu.getProvider(inventorySlot), b -> b.writeInt(slot));
            }
        }
        return InteractionResultHolder.success((Object)card);
    }
}

