/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.containers;

import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeable;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class UpgradeContainer
extends SimpleContainer {
    private final IUpgradeable parent;

    public UpgradeContainer(int size, IUpgradeable parent) {
        super(size);
        this.parent = parent;
    }

    public void copyContents(Container container) {
        this.clearContent();
        for (int i = 0; i < this.getContainerSize() && i < container.getContainerSize(); ++i) {
            this.setItem(i, container.getItem(i).copy());
        }
    }

    protected final boolean validUpgrade(ItemStack stack) {
        UpgradeItem upgrade;
        Item item = stack.getItem();
        return item instanceof UpgradeItem && this.parent.allowUpgrade(upgrade = (UpgradeItem)item) && UpgradeItem.noUniqueConflicts(upgrade, (Container)this);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.validUpgrade(stack);
    }

    public int getMaxStackSize() {
        return 1;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public ItemStack addItem(ItemStack stack) {
        if (this.canPlaceItem(0, stack)) {
            return super.addItem(stack);
        }
        return stack;
    }

    public boolean canAddItem(ItemStack stack) {
        return this.validUpgrade(stack) && super.canAddItem(stack);
    }

    public void save(String key, CompoundTag tag, HolderLookup.Provider lookup) {
        InventoryUtil.saveAllItems(key, tag, (Container)this, lookup);
    }

    public void load(String key, CompoundTag tag, HolderLookup.Provider lookup) {
        if (tag.contains(key)) {
            this.copyContents((Container)InventoryUtil.loadAllItems(key, tag, this.getContainerSize(), lookup));
        }
    }
}

