/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.gacha_machine;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.menus.MoneySlot;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.IMoneyCollectionMenu;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.IValidatedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaTrader;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class GachaMachineMenu
extends LazyMessageMenu
implements IValidatedMenu,
IMoneyCollectionMenu {
    private final long traderID;
    private final Container coins;
    List<Slot> coinSlots = new ArrayList<Slot>();
    private final List<ItemStack> rewards = new ArrayList<ItemStack>();
    private final MenuValidator validator;

    @Nullable
    public GachaTrader getTrader() {
        TraderData traderData = TraderAPI.getApi().GetTrader(this, this.traderID);
        if (traderData instanceof GachaTrader) {
            GachaTrader trader = (GachaTrader)traderData;
            return trader;
        }
        return null;
    }

    public final boolean hasPendingReward() {
        return !this.rewards.isEmpty();
    }

    public final ItemStack getNextReward() {
        if (this.rewards.isEmpty()) {
            return null;
        }
        return this.rewards.getFirst();
    }

    public final ItemStack getAndRemoveNextReward() {
        if (this.rewards.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return this.rewards.removeFirst();
    }

    @Override
    @Nonnull
    public MenuValidator getValidator() {
        return this.validator;
    }

    public GachaMachineMenu(int windowID, Inventory inventory, long traderID, @Nonnull MenuValidator validator) {
        super(ModMenus.GACHA_MACHINE.get(), windowID, inventory);
        int x;
        this.validator = validator;
        this.traderID = traderID;
        this.coins = new SimpleContainer(5);
        this.addValidator(this.validator);
        this.addValidator(() -> this.getTrader() != null);
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.addSlot(new Slot((Container)inventory, x2 + y * 9 + 9, 8 + x2 * 18, 140 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inventory, x, 8 + x * 18, 198));
        }
        for (x = 0; x < this.coins.getContainerSize(); ++x) {
            this.coinSlots.add(this.addSlot(new MoneySlot(this.coins, x, 8 + (x + 4) * 18, 108, this.player)));
        }
        GachaTrader trader = this.getTrader();
        if (trader != null) {
            trader.userOpen(this.player);
        }
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            clickedStack = slotStack.copy();
            if (index < 36 ? !this.moveItemStackTo(slotStack, 36, this.slots.size(), false) : index < this.slots.size() && !this.moveItemStackTo(slotStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return clickedStack;
    }

    public void removed(@Nonnull Player player) {
        super.removed(player);
        for (ItemStack reward : this.rewards) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)reward);
        }
        this.rewards.clear();
        this.clearContainer(player, this.coins);
        GachaTrader trader = this.getTrader();
        if (trader != null) {
            trader.userClose(this.player);
        }
    }

    public final TradeContext getContext() {
        return this.getContext(null);
    }

    public final TradeContext getContext(@Nullable Container rewardHolder) {
        TradeContext.Builder builder = TradeContext.create((TraderData)this.getTrader(), this.player).withCoinSlots(this.coins);
        if (rewardHolder != null) {
            builder.withItemHandler((IItemHandler)new InvWrapper(rewardHolder));
        }
        return builder.build();
    }

    @Override
    public void CollectStoredMoney() {
        if (this.getTrader() != null) {
            GachaTrader trader = this.getTrader();
            trader.CollectStoredMoney(this.player);
        }
    }

    private void ExecuteTrades(int count) {
        if (!this.rewards.isEmpty()) {
            return;
        }
        GachaTrader trader = this.getTrader();
        if (trader != null) {
            boolean flag = true;
            for (int i = 0; flag && i < count; ++i) {
                SimpleContainer result = new SimpleContainer(1);
                if (trader.TryExecuteTrade(this.getContext((Container)result), 0).isSuccess()) {
                    if (result.isEmpty()) {
                        LightmansCurrency.LogError("Successful Gacha Machine Trade executed, but no item was received!");
                        continue;
                    }
                    this.rewards.add(result.getItem(0));
                    continue;
                }
                flag = false;
            }
            if (!this.rewards.isEmpty()) {
                CompoundTag rewardData = new CompoundTag();
                InventoryUtil.saveAllItems("Rewards", rewardData, (Container)InventoryUtil.buildInventory(this.rewards), (HolderLookup.Provider)this.registryAccess());
                this.SendMessageToClient(this.builder().setInt("RewardCount", this.rewards.size()).setCompound("SyncRewards", rewardData));
            }
        }
    }

    public boolean GiveNextReward() {
        ItemStack reward = this.getAndRemoveNextReward();
        if (reward.isEmpty()) {
            return false;
        }
        ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)reward);
        return true;
    }

    @Override
    public void HandleMessage(@Nonnull LazyPacketData message) {
        if (message.contains("ExecuteTrade")) {
            if (!this.rewards.isEmpty()) {
                return;
            }
            this.ExecuteTrades(message.getInt("ExecuteTrade"));
        }
        if (message.contains("GiveNextReward")) {
            this.GiveNextReward();
        }
        if (message.contains("AnimationsCompleted")) {
            while (this.GiveNextReward()) {
            }
        }
        if (message.contains("SyncRewards")) {
            this.rewards.clear();
            CompoundTag rewardData = message.getNBT("SyncRewards");
            this.rewards.addAll((Collection<ItemStack>)InventoryUtil.buildList((Container)InventoryUtil.loadAllItems("Rewards", rewardData, message.getInt("RewardCount"), (HolderLookup.Provider)this.registryAccess())));
        }
    }
}

