/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.teams;

import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.common.menus.TeamManagementMenu;
import io.github.lightman314.lightmanscurrency.common.menus.tabbed.EasyMenuTab;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;

public abstract class TeamManagementTab
extends EasyMenuTab<TeamManagementMenu, TeamManagementTab> {
    public TeamManagementTab(@Nonnull TeamManagementMenu menu) {
        super(menu);
    }

    public static abstract class BankManagement
    extends Management {
        public BankManagement(@Nonnull TeamManagementMenu menu) {
            super(menu);
        }

        @Override
        protected boolean canAccess(@Nonnull Player player, @Nonnull ITeam team) {
            return super.canAccess(player, team) && team.hasBankAccount();
        }
    }

    public static abstract class Management
    extends TeamManagementTab {
        public Management(@Nonnull TeamManagementMenu menu) {
            super(menu);
        }

        @Override
        public final boolean canOpen(Player player) {
            ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
            return team != null && this.canAccess(player, team);
        }

        @Nonnull
        protected abstract AccessLevel accessLevel();

        protected boolean canAccess(@Nonnull Player player, @Nonnull ITeam team) {
            return switch (this.accessLevel().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> team.isOwner(player);
                case 1 -> team.isAdmin(player);
                case 2 -> team.isMember(player);
            };
        }

        protected static enum AccessLevel {
            OWNER,
            ADMINS,
            MEMBERS;

        }
    }
}

