/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traderinterface.handlers;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettings;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.DirectionalSettingsState;
import io.github.lightman314.lightmanscurrency.api.misc.settings.directional.IDirectionalSettingsObject;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.SidedHandler;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class ConfigurableSidedHandler<H>
extends SidedHandler<H>
implements IDirectionalSettingsObject {
    protected final DirectionalSettings directionalSettings = new DirectionalSettings(this);
    protected static final String UPDATE_SIDE = "updateSide";
    private final ImmutableList<Direction> ignoreSides;

    protected ConfigurableSidedHandler() {
        this((ImmutableList<Direction>)ImmutableList.of());
    }

    protected ConfigurableSidedHandler(ImmutableList<Direction> ignoreSides) {
        this.ignoreSides = ignoreSides;
    }

    @Override
    public List<Direction> getIgnoredSides() {
        return this.ignoreSides;
    }

    @Override
    public DirectionalSettingsState getSidedState(Direction side) {
        return this.directionalSettings.getState(side);
    }

    @Override
    @Nullable
    public Block getDisplayBlock() {
        TraderInterfaceBlockEntity be = this.getParent();
        return be == null ? null : be.getBlockState().getBlock();
    }

    public void toggleSide(Direction side, DirectionalSettingsState newState) {
        if (this.getSidedState(side) == newState) {
            return;
        }
        this.directionalSettings.setState(side, newState);
        this.markDirty();
        if (this.isClient()) {
            CompoundTag message = ConfigurableSidedHandler.initUpdateInfo(UPDATE_SIDE);
            message.putInt("side", side.get3DDataValue());
            message.putString("newValue", newState.toString());
            this.sendMessage(message);
        }
    }

    public static CompoundTag initUpdateInfo(String updateType) {
        CompoundTag compound = new CompoundTag();
        compound.putString("UpdateType", updateType);
        return compound;
    }

    public static boolean isUpdateType(CompoundTag updateInfo, String updateType) {
        if (updateInfo.contains("UpdateType", 8)) {
            return updateInfo.getString("UpdateType").contentEquals(updateType);
        }
        return false;
    }

    @Override
    public void receiveMessage(CompoundTag compound) {
        if (ConfigurableSidedHandler.isUpdateType(compound, UPDATE_SIDE)) {
            Direction side = Direction.from3DDataValue((int)compound.getInt("side"));
            DirectionalSettingsState state = DirectionalSettingsState.parse(compound.getString("newValue"));
            if (state != this.getSidedState(side)) {
                this.toggleSide(side, state);
            }
        }
    }

    @Override
    public final CompoundTag save(HolderLookup.Provider lookup) {
        CompoundTag compound = new CompoundTag();
        this.directionalSettings.save(compound, "InputOutputSides");
        this.saveAdditional(compound, lookup);
        return compound;
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
    }

    @Override
    public void load(CompoundTag compound, HolderLookup.Provider lookup) {
        CompoundTag entry;
        this.directionalSettings.load(compound, "InputOutputSides");
        if (compound.contains("InputSides", 10)) {
            entry = compound.getCompound("InputSides");
            for (Direction side : Direction.values()) {
                if (this.ignoreSides.contains((Object)side) || !compound.contains(side.toString()) || !compound.getBoolean(side.toString())) continue;
                this.directionalSettings.setState(side, DirectionalSettingsState.INPUT);
            }
        }
        if (compound.contains("OutputSides", 10)) {
            entry = compound.getCompound("OutputSides");
            for (Direction side : Direction.values()) {
                if (this.ignoreSides.contains((Object)side) || !compound.contains(side.toString()) || !compound.getBoolean(side.toString())) continue;
                DirectionalSettingsState state = this.directionalSettings.getState(side);
                if (state.allowsInputs()) {
                    this.directionalSettings.setState(side, DirectionalSettingsState.INPUT_AND_OUTPUT);
                    continue;
                }
                this.directionalSettings.setState(side, DirectionalSettingsState.OUTPUT);
            }
        }
    }
}

