/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.ticket;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.menus.slots.ticket.TicketSlot;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.ticket.TicketItemTrade;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.ItemRequirement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TicketKioskRestriction
extends ItemTradeRestriction {
    public static TicketKioskRestriction REGISTERED_INSTANCE = new TicketKioskRestriction(new TicketItemTrade(false));
    private final TicketItemTrade trade;

    public TicketKioskRestriction(TicketItemTrade trade) {
        this.trade = trade;
    }

    @Override
    public ResourceLocation getType() {
        return TicketKioskRestriction.getId(REGISTERED_INSTANCE);
    }

    @Override
    public ItemStack modifySellItem(ItemStack sellItem, String customName, ItemTradeData trade, int index) {
        if (trade != this.trade) {
            return sellItem;
        }
        TicketItemTrade.TicketSaleData data = this.trade.getTicketData(index);
        if (data == null) {
            return sellItem;
        }
        return data.getCraftingResult(true);
    }

    @Override
    public boolean displayCustomName(ItemStack sellItem, ItemTradeData trade, int index) {
        if (trade != this.trade) {
            return true;
        }
        TicketItemTrade.TicketSaleData data = this.trade.getTicketData(index);
        return data != null && data.isRecipeMode();
    }

    @Override
    public boolean allowSellItem(ItemStack itemStack) {
        if (TicketItem.isMasterTicket(itemStack)) {
            return true;
        }
        return InventoryUtil.ItemHasTag(itemStack, LCTags.Items.TICKET_MATERIAL) && !TicketItem.isTicketOrPass(itemStack);
    }

    @Override
    public ItemStack filterSellItem(ItemStack itemStack) {
        if (TicketItem.isMasterTicket(itemStack)) {
            return itemStack;
        }
        if (InventoryUtil.ItemHasTag(itemStack, LCTags.Items.TICKET_MATERIAL) && !TicketItem.isTicketOrPass(itemStack)) {
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean allowItemSelectItem(ItemStack itemStack) {
        return InventoryUtil.ItemHasTag(itemStack, LCTags.Items.TICKET_MATERIAL) && !InventoryUtil.ItemHasTag(itemStack, LCTags.Items.TICKETS);
    }

    @Override
    public boolean allowFilters() {
        return false;
    }

    @Override
    public boolean allowExtraItemInStorage(ItemStack itemStack) {
        return InventoryUtil.ItemHasTag(itemStack, LCTags.Items.TICKET_MATERIAL);
    }

    @Override
    public int getSaleStock(TraderItemStorage traderStorage, ItemTradeData trade) {
        if (trade != this.trade) {
            LightmansCurrency.LogWarning("Attempted to get stock for a ticket trade that didn't match its restriction!");
            return 0;
        }
        ArrayList countByRecipe = new ArrayList();
        int minStock = Integer.MAX_VALUE;
        ArrayList<ItemRequirement> requirements = new ArrayList<ItemRequirement>();
        for (int i = 0; i < 2; ++i) {
            ItemStack sellItem = trade.getActualItem(i);
            TicketItemTrade.TicketSaleData data = this.trade.getTicketData(i);
            if (data.isRecipeMode()) {
                TicketStationRecipe recipe = data.tryGetRecipe();
                if (recipe == null) {
                    return 0;
                }
                this.addToList(recipe.getKioskStorageRequirement(sellItem), requirements);
                continue;
            }
            this.addToList(ItemRequirement.of(sellItem), requirements);
        }
        if (requirements.isEmpty()) {
            return 0;
        }
        for (ItemRequirement entry : requirements) {
            if (entry.getCount() <= 0) continue;
            minStock = traderStorage.getItemCount(entry) / entry.getCount();
        }
        return minStock;
    }

    private void addToList(ItemRequirement requirement, List<ItemRequirement> list) {
        for (ItemRequirement entry : list) {
            if (!entry.tryMerge(requirement)) continue;
            return;
        }
        list.add(requirement);
    }

    @Override
    public List<ItemStack> getRandomSellItems(ItemTraderData trader, ItemTradeData trade) {
        if (trade != this.trade) {
            return null;
        }
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        ArrayList<ItemTradeRestriction.RequirementWithContext> normalSellItems = new ArrayList<ItemTradeRestriction.RequirementWithContext>();
        for (int i = 0; i < 2; ++i) {
            TicketItemTrade.TicketSaleData data = this.trade.getTicketData(i);
            if (data.isRecipeMode()) {
                results.add(data.getCraftingResult(true));
                continue;
            }
            if (this.trade.getActualItem(i).isEmpty()) continue;
            normalSellItems.add(new ItemTradeRestriction.RequirementWithContext(trade, i));
        }
        if (!normalSellItems.isEmpty()) {
            List<ItemStack> normal = this.getRandomSellItems(trader, normalSellItems);
            if (normal == null) {
                return null;
            }
            results.addAll(normal);
        }
        return results;
    }

    @Override
    public void removeItemsFromStorage(TraderItemStorage traderStorage, List<ItemStack> soldItems) {
        ArrayList<ItemRequirement> ingredients = new ArrayList<ItemRequirement>();
        ArrayList<ItemStack> ignoreIfPossible = new ArrayList<ItemStack>();
        for (int i = 0; i < 2; ++i) {
            ItemStack sellItem = this.trade.getSellItem(i);
            ItemStack actualItem = this.trade.getActualItem(i);
            TicketItemTrade.TicketSaleData data = this.trade.getTicketData(i);
            if (data.isRecipeMode()) {
                TicketStationRecipe recipe = data.tryGetRecipe();
                if (recipe == null) continue;
                this.addToList(recipe.getKioskStorageRequirement(sellItem), ingredients);
                continue;
            }
            this.removeFromStorage(sellItem, traderStorage);
            ignoreIfPossible.add(sellItem);
            ignoreIfPossible.add(actualItem);
        }
        List<Item> masterTickets = InventoryUtil.GetItemsWithTag(LCTags.Items.TICKETS_MASTER);
        for (ItemRequirement entry : ingredients) {
            traderStorage.removeItemCount(entry, entry.getCount(), ignoreIfPossible, s -> masterTickets.stream().anyMatch(e -> e == s.getItem()));
        }
    }

    @Override
    public boolean alwaysEnforceNBT(int tradeSlot) {
        return tradeSlot < 2;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Pair<ResourceLocation, ResourceLocation> getEmptySlotBG() {
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)TicketSlot.EMPTY_TICKET_SLOT);
    }
}

