/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.common.loot;

import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public abstract class SimpleSubProvider
implements LootTableSubProvider {
    protected final HolderLookup.Provider lookup;
    private BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer;

    public SimpleSubProvider(HolderLookup.Provider lookup) {
        this.lookup = lookup;
    }

    protected LootItemCondition.Builder hasSilkTouch() {
        HolderLookup.RegistryLookup registrylookup = this.lookup.lookupOrThrow(Registries.ENCHANTMENT);
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)registrylookup.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1))))));
    }

    protected EnchantedCountIncreaseFunction.Builder addLootingBonus(NumberProvider numberProvider) {
        return EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.lookup, (NumberProvider)numberProvider);
    }

    public void generate(@Nonnull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        this.consumer = consumer;
        this.generate();
    }

    protected abstract void generate();

    protected final void register(ResourceKey<LootTable> table, LootTable.Builder builder) {
        this.consumer.accept(table, builder);
    }

    protected final void register(ResourceLocation table, LootTable.Builder builder) {
        this.register((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)table), builder);
    }
}

