/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.common.structures;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.common.loot.LCLootTables;
import io.github.lightman314.lightmanscurrency.common.world.LCStructures;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;
import net.minecraft.world.level.storage.loot.LootTable;

public class LCProcessorListProvider {
    public static void bootstrap(@Nonnull BootstrapContext<StructureProcessorList> context) {
        context.register(LCStructures.PROCESSOR_DESERT_BANKER_ARCHAEOLOGY, (Object)new StructureProcessorList((List)Lists.newArrayList((Object[])new StructureProcessor[]{LCProcessorListProvider.archaeologyRule(LCLootTables.ARCHAEOLOGY_VILLAGE_DESERT_BANKER, Blocks.SUSPICIOUS_SAND, Blocks.SUSPICIOUS_SAND.defaultBlockState(), 10)})));
        context.register(LCStructures.PROCESSOR_PLAINS_SHOP_ARCHAEOLOGY, (Object)new StructureProcessorList((List)Lists.newArrayList((Object[])new StructureProcessor[]{LCProcessorListProvider.gravelArchaeology(LCLootTables.ARCHAEOLOGY_VILLAGE_PLAINS_SHOP, 4)})));
        context.register(LCStructures.PROCESSOR_TAIGA_SHOP_ARCHAEOLOGY, (Object)new StructureProcessorList((List)Lists.newArrayList((Object[])new StructureProcessor[]{LCProcessorListProvider.gravelArchaeology(LCLootTables.ARCHAEOLOGY_VILLAGE_TAIGA_SHOP, 4)})));
        context.register(LCStructures.PROCESSOR_DESERT_SHOP_ARCHAEOLOGY, (Object)new StructureProcessorList((List)Lists.newArrayList((Object[])new StructureProcessor[]{LCProcessorListProvider.sandArchaeology(LCLootTables.ARCHAEOLOGY_VILLAGE_DESERT_SHOP, 10)})));
        context.register(LCStructures.PROCESSOR_ANCIENT_RUINS, (Object)new StructureProcessorList((List)Lists.newArrayList((Object[])new StructureProcessor[]{LCProcessorListProvider.gravelArchaeology(LCLootTables.ARCHAEOLOGY_ANCIENT_RUINS, 6)})));
    }

    private static CappedProcessor gravelArchaeology(ResourceLocation lootTable, int count) {
        return LCProcessorListProvider.gravelArchaeology((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable), count);
    }

    private static CappedProcessor gravelArchaeology(ResourceKey<LootTable> lootTable, int count) {
        return LCProcessorListProvider.archaeologyRule(lootTable, Blocks.GRAVEL, Blocks.SUSPICIOUS_GRAVEL.defaultBlockState(), count);
    }

    private static CappedProcessor sandArchaeology(ResourceLocation lootTable, int count) {
        return LCProcessorListProvider.sandArchaeology((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable), count);
    }

    private static CappedProcessor sandArchaeology(ResourceKey<LootTable> lootTable, int count) {
        return LCProcessorListProvider.archaeologyRule(lootTable, Blocks.SAND, Blocks.SUSPICIOUS_SAND.defaultBlockState(), count);
    }

    private static CappedProcessor archaeologyRule(ResourceLocation lootTable, Block original, BlockState replacement, int count) {
        return LCProcessorListProvider.archaeologyRule((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable), original, replacement, count);
    }

    private static CappedProcessor archaeologyRule(ResourceKey<LootTable> lootTable, Block original, BlockState replacement, int count) {
        return new CappedProcessor((StructureProcessor)new RuleProcessor((List)Lists.newArrayList((Object[])new ProcessorRule[]{new ProcessorRule((RuleTest)new BlockMatchTest(original), (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)PosAlwaysTrueTest.INSTANCE, replacement, (RuleBlockEntityModifier)new AppendLoot(lootTable))})), (IntProvider)ConstantInt.of((int)count));
    }

    private static RuleProcessor chestLoot(ResourceLocation lootTable, BlockState state) {
        return LCProcessorListProvider.chestLoot((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTable), state);
    }

    private static RuleProcessor chestLoot(ResourceKey<LootTable> lootTable, BlockState state) {
        return new RuleProcessor((List)Lists.newArrayList((Object[])new ProcessorRule[]{new ProcessorRule((RuleTest)new BlockMatchTest(state.getBlock()), (RuleTest)AlwaysTrueTest.INSTANCE, (PosRuleTest)PosAlwaysTrueTest.INSTANCE, state, (RuleBlockEntityModifier)new AppendLoot(lootTable))}));
    }
}

