/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.mixin;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.attachments.wallet.WalletHelpers;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.slots.WalletSlot;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.mixin.AbstractContainerMenuAccessor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={InventoryMenu.class})
public abstract class InventoryMenuMixin {
    @Unique
    private Slot lightmanscurrency$walletSlot = null;

    @Unique
    private InventoryMenu lightmanscurrency$self() {
        return (InventoryMenu)this;
    }

    @Accessor(value="owner")
    protected abstract Player getPlayer();

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    protected void init(Inventory inventory, boolean active, Player player, CallbackInfo callbackInfo) {
        if (LCCurios.isLoaded()) {
            return;
        }
        InventoryMenu inventoryMenu = this.lightmanscurrency$self();
        if (inventoryMenu instanceof AbstractContainerMenuAccessor) {
            AbstractContainerMenuAccessor accessor = (AbstractContainerMenuAccessor)inventoryMenu;
            this.lightmanscurrency$walletSlot = accessor.addCustomSlot(new WalletSlot(player, WalletHelpers.getWalletContainer((LivingEntity)player), 0, ((ScreenPosition)LCConfig.CLIENT.walletSlot.get()).x + 1, ((ScreenPosition)LCConfig.CLIENT.walletSlot.get()).y + 1));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"quickMoveStack"}, cancellable=true)
    protected void quickMoveStack(Player player, int slotIndex, CallbackInfoReturnable<ItemStack> callbackInfo) {
        Slot slot;
        if (LCCurios.isLoaded()) {
            return;
        }
        if (slotIndex >= 9 && slotIndex < 45 && this.lightmanscurrency$walletSlot != null && (slot = (Slot)this.lightmanscurrency$self().slots.get(slotIndex)).hasItem() && WalletItem.isWallet(slot.getItem()) && !this.lightmanscurrency$walletSlot.hasItem()) {
            this.lightmanscurrency$walletSlot.set(slot.getItem().copy());
            slot.set(ItemStack.EMPTY);
            callbackInfo.setReturnValue((Object)ItemStack.EMPTY);
        }
    }
}

